from dataclasses import dataclass
from typing import Any
from pot_libs.sanic_api import Model
from pot_libs.sanic_api.column import Str, Int, Dict, Opt, Schema, Float


class RequestId(Schema):
    schema = Str('uuid').eg('7c60bc30-cbad-4002-9c13-e700aa8c9eb9')


class Turns(Schema):
    schema = Str('执行次数').eg(1)


class Interval(Schema):
    schema = Float('执行时间间隔s').eg(2)


class Time(Schema):
    schema = Str('时间').eg('2020-04-21 11:39:56')


@dataclass
class BaseResponse(Model):
    request_id: str = Str('请求id，用于跟踪请求').eg('test01')
    status_code: int = Int('状态码，含义与HTTP状态玛相同').eg(200)
    data: Any = Opt(Dict())
    message: str = Opt(Str('附加消息'))
    type: str = Opt(Str('字段类型'))
    sid: str = Opt(Str('sid'))
    software_version: str = Opt(Str('软件版本'))


@dataclass
class ScopeOptionResponse(Model):
    tooltip: dict
    legend: dict
    xAxis: dict
    yAxis: dict
    dataZoom: list
    series: list
