from unify_api.tests.constants_t import post_request
import json
import pytest
import logging
from unify_api.tests.constants_t import TOKEN, HTTP_PREFIX
from pot_libs.aiohttp_util.aiohttp_utils import AioHttpUtils


@pytest.mark.parametrize('data', [
    {
        "cid": 54
    },
])
@pytest.mark.asyncio
async def test_post_electric_economic_index_new(data):
    """测试用电优化-空间汇总"""
    " pytest -s -v test_power.py::test_post_electric_economic_index_new"
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/home-page/count-info/"
            f"electric-economic-index-new",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    resp_str = json.loads(resp_str)
    logging.info(f"用电优化-空间汇总:{resp_str}")
    assert status == 200
    assert isinstance(resp_str["data"]["power_factor"]["index"], float) is True
    assert isinstance(resp_str["data"]["md_space"]["index"], float) is True
    assert isinstance(resp_str["data"]["pcvf"]["index"], float) is True
    assert isinstance(resp_str["data"]["power_save"]["index"], float) is True


@pytest.mark.parametrize('data', [
    {
        "inline_id": 57
    },
])
@pytest.mark.asyncio
async def test_post_md_space(data):
    """用电优化-需量管理-根据进线id"""
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/electric-optimization/optimization/"
            f"md-space",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    resp_str = json.loads(resp_str)
    logging.info(f"需量管理:{resp_str}")
    assert status == 200
    assert type(resp_str["data"]["inline_md_predict"]) in [int, float]
    assert type(resp_str["data"]["tc_runtime"]) in [int, float]
    assert type(resp_str["data"]["price_md"]) in [int, float]
    assert type(resp_str["data"]["price_tc"]) in [int, float]


@pytest.mark.parametrize('data', [
    {
        "inline_id": 59
    },
])
@pytest.mark.asyncio
async def test_post_power_factor(data):
    """用电优化-功率因素-根据进线id"""
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/electric-optimization/optimization/"
            f"power-factor",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    resp_str = json.loads(resp_str)
    logging.info(f"功率因素:{resp_str}")
    assert status == 200
    assert type(resp_str["data"]["power_factor"]) in [int, float]
    assert type(resp_str["data"]["punish_money"]) in [int, float]
    # 功率因数指数小于0.9，不会返回save_charge
    if resp_str["data"]["power_factor"] < 0.9:
        assert type(resp_str["data"].get("save_charge")) in [int, float]


@pytest.mark.parametrize('data', [
    {
        "inline_id": 57
    },
])
@pytest.mark.asyncio
async def test_post_power_peakcut(data):
    """用电优化-移峰填谷-根据进线id"""
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/electric-optimization/optimization/"
            f"power-peakcut",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    resp_str = json.loads(resp_str)
    logging.info(f"移峰填谷:{resp_str}")
    assert status == 200
    assert type(resp_str["data"]["pcvf_index"]) in [int, float]
    assert type(resp_str["data"]["avg_price"]) in [int, float]
    assert type(resp_str["data"]["save_charge"]) in [int, float]
    assert type(resp_str["data"]["price_f"]) in [int, float]
    assert type(resp_str["data"]["growth_percentage"]) in [int, float]


@pytest.mark.parametrize('data', [
    {
        "inline_id": 57
    },
])
@pytest.mark.asyncio
async def test_post_power_save(data):
    """用电优化-经济运行-根据进线id"""
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/electric-optimization/optimization/power-save",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    resp_str = json.loads(resp_str)
    logging.info(f"经济运行:{resp_str}")
    assert status == 200
    assert type(resp_str["data"]["avg_load_rate"]) in [int, float]
    assert type(resp_str["data"]["save_charge"]) in [int, float]
