# /usr/bin/env python
# -*- coding: UTF-8 -*-
from __future__ import division
from numpy import floor


def filterStrength(data, length, ctnum):
    mainFlag = 0
    current_hist = []
    volt_hist = []
    if length <= 6000:
        sep = 80
        points = int(floor(length / 80))
    elif length <= 12800:
        sep = 160
        points = int(floor(length / 160))
    elif length <= 20000:
        sep = 250
        points = int(floor(length / 250))
    else:
        sep = 330
        points = int(floor(length / 330))

    if ctnum == 3:

        for i in ['ia', 'ib', 'ic']:
            currentList = data[i]
            current = [x for x in currentList]
            maxValues = [max(current[sep * j:sep * (j + 1)]) for j in range(points)]
            minValues = [min(current[sep * j:sep * (j + 1)]) for j in range(points)]

            max_Values_len = len(maxValues) - 1
            for eachDiff in range(max_Values_len):
                if eachDiff == 0:
                    continue
                else:
                    if abs(eachDiff - maxValues[eachDiff - 1]) > 0.1 * max(maxValues[
                                                                                       eachDiff - 1],
                                                                           maxValues[0]) and abs(
                                eachDiff - maxValues[eachDiff + 1]) > 0.1 * max(maxValues[
                                                                                            eachDiff + 1],
                                                                                maxValues[0]) and abs(
                                maxValues[eachDiff + 1] - maxValues[-1]) > 0.1 * max(maxValues[
                                                                                                 eachDiff - 1],
                                                                                     maxValues[0]):
                        current_hist.append(eachDiff)

            for eachDiff in range(max_Values_len):
                if eachDiff == 0:
                    continue
                else:
                    if abs(eachDiff - minValues[eachDiff - 1]) > -0.1 * min(minValues[
                                                                                        eachDiff - 1],
                                                                            minValues[0]) and abs(
                                eachDiff - minValues[eachDiff + 1]) > -0.1 * min(minValues[
                                                                                             eachDiff + 1],
                                                                                 minValues[0]) and abs(
                                minValues[eachDiff + 1] - minValues[-1]) > 0.1 * max(maxValues[
                                                                                                 eachDiff - 1],
                                                                                     maxValues[0]):
                        current_hist.append(eachDiff)

        for i in ['ua', 'ub', 'uc']:
            currentList = data[i]
            current = [x for x in currentList]
            maxValues = [max(current[sep * j:sep * (j + 1)]) for j in range(points)]
            minValues = [min(current[sep * j:sep * (j + 1)]) for j in range(points)]

            max_Values_len = len(maxValues) - 1
            for eachDiff in range(max_Values_len):
                if eachDiff == 0:
                    continue
                else:
                    a = 0.1 * max(maxValues[eachDiff - 1], maxValues[0])
                    if maxValues[eachDiff] - maxValues[eachDiff - 1] < -a and maxValues[eachDiff - 1] - maxValues[
                                eachDiff + 1] > a and maxValues[eachDiff] - maxValues[0] < -a and abs(
                                maxValues[eachDiff] - maxValues[
                            -2]) > a:
                        volt_hist.append(eachDiff)

            for eachDiff in range(max_Values_len):
                if eachDiff == 0:
                    continue
                else:
                    if minValues[eachDiff] - minValues[eachDiff - 1] > -0.1 * minValues[eachDiff - 1] and minValues[
                                eachDiff - 1] - minValues[eachDiff + 1] < 0.1 * minValues[eachDiff - 1] and minValues[
                        eachDiff] - minValues[0] > -0.1 * minValues[eachDiff - 1]:
                        volt_hist.append(eachDiff)

        interSet = set(current_hist) & set(volt_hist)

        if len(interSet) > 0:
            mainFlag = 1

    elif ctnum == 2:

        for i in ['iab', 'ibc']:
            currentList = data[i]
            current = [x for x in currentList]
            maxValues = [max(current[sep * j:sep * (j + 1)]) for j in range(points)]
            minValues = [min(current[sep * j:sep * (j + 1)]) for j in range(points)]

            max_Values_len = len(maxValues) - 1
            for eachDiff in range(max_Values_len):
                if eachDiff == 0:
                    continue
                else:
                    if abs(maxValues[eachDiff] - maxValues[eachDiff - 1]) > 0.1 * max(maxValues[
                                                                                                  eachDiff - 1],
                                                                                      maxValues[0]) and abs(
                                maxValues[eachDiff] - maxValues[eachDiff + 1]) > 0.1 * max(maxValues[
                                                                                                       eachDiff - 1],
                                                                                           maxValues[0]) and abs(
                                maxValues[eachDiff + 1] - maxValues[-1]) > 0.1 * max(maxValues[
                                                                                                 eachDiff - 1],
                                                                                     maxValues[0]):
                        current_hist.append(eachDiff)

            for eachDiff in range(max_Values_len):
                if eachDiff == 0:
                    continue
                else:
                    if abs(minValues[eachDiff] - minValues[eachDiff - 1]) > -0.1 * min(minValues[
                                                                                                   eachDiff - 1],
                                                                                       minValues[0]) and abs(
                                minValues[eachDiff] - minValues[eachDiff + 1]) > -0.1 * min(minValues[
                                                                                                        eachDiff - 1],
                                                                                            minValues[0]) and abs(
                                minValues[eachDiff + 1] - minValues[-1]) > 0.1 * max(maxValues[
                                                                                                 eachDiff - 1],
                                                                                     maxValues[0]):
                        current_hist.append(eachDiff)

        for i in ['uab', 'ubc']:
            currentList = data[i]
            current = [x for x in currentList]
            maxValues = [max(current[sep * j:sep * (j + 1)]) for j in range(points)]
            minValues = [min(current[sep * j:sep * (j + 1)]) for j in range(points)]

            max_Values_len = len(maxValues) - 1
            for eachDiff in range(max_Values_len):
                if eachDiff == 0:
                    continue
                else:
                    a = 0.1 * max(maxValues[eachDiff - 1], maxValues[0])
                    if maxValues[eachDiff] - maxValues[eachDiff - 1] < -a and maxValues[eachDiff - 1] - maxValues[
                                eachDiff + 1] > a and maxValues[eachDiff] - maxValues[0] < -a and abs(
                                maxValues[eachDiff] - maxValues[
                            -2]) > a:
                        volt_hist.append(eachDiff)

            for eachDiff in range(max_Values_len):
                if eachDiff == 0:
                    continue
                else:
                    if minValues[eachDiff] - minValues[eachDiff - 1] > -0.1 * minValues[eachDiff - 1] and minValues[
                                eachDiff - 1] - minValues[eachDiff + 1] < 0.1 * minValues[eachDiff - 1] and minValues[
                        eachDiff] - minValues[0] > -0.1 * minValues[eachDiff - 1]:
                        volt_hist.append(eachDiff)
    interSet = set(current_hist) & set(volt_hist)

    if len(interSet) > 0:
        mainFlag = 1

    return mainFlag
