
from pot_libs.mysql_util.mysql_util import MysqlUtil


async def get_pid_by_mtid(mtid):
    sql = "select pid from point where mtid = %s"
    async with MysqlUtil() as conn:
        data = await conn.fetchone(sql, args=(mtid,))
    return data


async def get_mtid_by_sid(sid):
    sql = "select mtid,name,cid,sid from monitor where sid = %s and " \
          "demolished=0"
    async with MysqlUtil() as conn:
        data = await conn.fetchall(sql, args=(sid,))
    return data


async def get_mtids_by_pid(sid):
    sql = "select mtid from point where pid = %s"
    async with MysqlUtil() as conn:
        data = await conn.fetchall(sql, args=(sid,))
    return data


async def get_mtid_by_pid(pid):
    sql = "select mtid from point where pid = %s"
    async with MysqlUtil() as conn:
        data = await conn.fetchone(sql, args=(pid,))
    return data


async def get_locationid_by_mtid(mtid, param):
    sql = "select lid id, item, ad_type type from location where mtid = %s " \
          "and ad_type = %s"
    async with MysqlUtil() as conn:
        data = await conn.fetchall(sql, args=(mtid, param))
    return data


async def get_params_by_mtid(mtid):
    sql = 'select DISTINCT ad_type as type from location where mtid = %s ' \
          'and ad_type in ("temperature", "residual_current")'
    async with MysqlUtil() as conn:
        data = await conn.fetchall(sql, args=(mtid,))
    return data


async def location_by_mtid(mtid):
    sql = "select * from location where mtid = %s"
    async with MysqlUtil() as conn:
        location_list = await conn.fetchall(sql, args=(mtid,))
    return location_list


async def get_info_by_mtid(mtid):
    sql = "select cid, sid, name, mtid from monitor where mtid = %s and " \
          "demolished=0"
    async with MysqlUtil() as conn:
        data = await conn.fetchall(sql, args=(mtid, ))
    return data


async def select_point_by_mtid(mtid):
    sql = "select pid, name from point where mtid = %s "
    async with MysqlUtil() as conn:
        data = await conn.fetchone(sql, args=(mtid,))
    return data


async def get_residual_current_threhold(location_id,
                                        type="overResidualCurrent"):
    sql = "select threshold from soe_config_record where " \
          "lid = %s and etype = %s "
    async with MysqlUtil() as conn:
        data = await conn.fetchone(sql, args=(location_id, type))
    return data


async def get_name_by_pid(pid):
    sql = "SELECT c.shortname,p.name FROM `point` p LEFT JOIN company c " \
          "on c.cid=p.cid where p.pid=%s"
    async with MysqlUtil() as conn:
        data = await conn.fetchone(sql, args=(pid,))
    return data
