# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.

import ujson
from unify_api.constants import SMS_LOGIN_TEMPLATE, SMS_SIGN_NAME
from typing import List
from pot_libs.logger import log
from pot_libs.settings import SETTING
from alibabacloud_dysmsapi20170525.client import Client as \
    Dysmsapi20170525Client
from alibabacloud_tea_openapi import models as open_api_models
from alibabacloud_dysmsapi20170525 import models as dysmsapi_20170525_models


class Sample:
    def __init__(self):
        pass

    @staticmethod
    def create_client(access_key_id: str, access_key_secret: str,) -> \
            Dysmsapi20170525Client:
        config = open_api_models.Config(
            access_key_id=SETTING.accesskey_id,
            access_key_secret=SETTING.accesskey_secret
        )
        # 访问的域名
        config.endpoint = 'dysmsapi.aliyuncs.com'
        return Dysmsapi20170525Client(config)

    @staticmethod
    def main(args: List[str],) -> None:
        """args: [phone, code]"""
        client = Sample.create_client('accessKeyId', 'accessKeySecret')
        data = {"code": args[1]}
        send_sms_request = dysmsapi_20170525_models.SendSmsRequest(
            phone_numbers=args[0],
            sign_name=SMS_SIGN_NAME,
            template_code=SMS_LOGIN_TEMPLATE,
            template_param=ujson.dumps(data),
        )
        log.info(f"send_sms phone: {args[0]} request_body = {args[1]}")
        result = client.send_sms(send_sms_request)
        log.info(f"send_sms phone: {args[0]} result = {result}")
        return result.body


sample = Sample()
# if __name__ == '__main__':
#     Sample.main(sys.argv[:1])
