from pot_libs.mysql_util.mysql_util import MysqlUtil


async def user_lock_auth_by_user_id(user_id):
    """根据user_id查询user_lock_auth"""
    sql = "SELECT * FROM user_lock_auth WHERE user_id = %s"
    async with MysqlUtil() as conn:
        lock_auth_list = await conn.fetchall(sql, args=(user_id,))
    return lock_auth_list


async def u_lock_by_mac(mac):
    sql = "SELECT * from u_lock where mac = %s "
    async with MysqlUtil() as conn:
        lock_dic = await conn.fetchone(sql, args=(mac,))
    return lock_dic


async def u_lock_by_id(lock_id):
    sql = "SELECT * from u_lock where id = %s "
    async with MysqlUtil() as conn:
        lock_dic = await conn.fetchone(sql, args=(lock_id,))
    return lock_dic
