from dataclasses import dataclass

from pot_libs.sanic_api import Model
from pot_libs.sanic_api.column import Str, List


@dataclass
class BlReq(Model):
    id: str = Str("id").eg("QK0000000001")


@dataclass
class BlResp(Model):
    secret_key: list = List("秘钥")
    password: list = List("密码")


@dataclass
class LiReq(Model):
    mac: str = Str("mac").eg("100270200483779D4D4D3200")


@dataclass
class LiResp(Model):
    id: str = Str("锁id").eg("QK0000000001")
