from dataclasses import dataclass

from pot_libs.common.components.fields import Cid
from pot_libs.sanic_api import Model
from pot_libs.sanic_api.column import Opt, Dict, Float, Str, Int, List
from unify_api.utils.response_code import DbErr, ParamErr, ServerErr


@dataclass
class CountInfoReq(Model):
    cid: Cid


@dataclass
class MaxTemperature(Model):
    max: float = Opt(Float("近30天最高溫度， 单位°C").eg(65.7))
    location_name: str = Opt(Str("出現最高溫度传感器名称").eg("蒸熊掌生产线"))
    occur_time: str = Opt(Str("出現最高溫度的時間").eg("2020-05-16 13:45"))


@dataclass
class MaxResidualCurrent(Model):
    """
    近30天漏电流
    """

    max: float = Opt(Float("近30天最大漏电流, 单位mA").eg(2))
    location_name: str = Opt(Str("出現最大漏电流传感器名称").eg("压缩机漏电流"))
    occur_time: str = Opt(Str("出現最大漏电流的時間").eg("2020-05-16 13:45"))


@dataclass
class ElectricInfo(Model):
    first_alarm_cnt: int = Opt(Int("一级报警数").eg(20))
    second_alarm_cnt: int = Opt(Int("二级报警数").eg(20))
    third_alarm_cnt: int = Opt(Int("二级报警数").eg(20))
    alarm_score: float = Opt(Float("报警分数").eg(20.0))
    electric_use_score: float = Opt(Float("用电安全指数").eg(90.3))


@dataclass
class CountInfoResp(Model, DbErr, ServerErr):
    max_temperature: MaxTemperature = MaxTemperature
    max_residual_current: MaxResidualCurrent = MaxResidualCurrent
    temperature_qr: str = Opt(Str("温度达标率").eg("80%"))
    residual_current_qr: str = Opt(Str("漏电流达标率").eg("97%"))
    current_load: float = Opt(Float("实时负荷, 单位kW").eg(860))
    max_30d_load: float = Opt(Float("近30日最高负荷, 单位kW").eg(950))
    today_alarm_count: int = Opt(Int("今日报警数").eg(12))
    safe_run_days: int = Opt(Int("累计安全运行").eg(36))
    electric_info: ElectricInfo = ElectricInfo
    yestoday_price: float = Opt(Float("昨日平均电价").eg(0.56))
    last_month_price: float = Opt(Float("上月平均电费").eg(0.4))
    cos_ttl: float = Opt(Float("实时功率因数").eg(0.9))
    last_month_cos: float = Opt(Float("上月功率因数").eg(0.9))


@dataclass
class CountItem(Model):
    index: float = Float("指标大小").eg(0.05)
    save_charge: float = Float("节约的电费, 单位万元").eg(1)
    desc: str = Str("指标描述").eg("合格")


@dataclass
class EconomicPowerCountResp(Model):
    power_factor: CountItem = CountItem
    md_space: CountItem = CountItem
    pcvf: CountItem = CountItem
    power_save: CountItem = CountItem
    save_percent: float = Float("节费率").eg(0.067)
    economic_power_index: float = Float("经济用电指数").eg(90)
    avg_price: float = Float("上个月平均电价").eg(0.86)
    md_space_p: float = Float("最大需量，单位kw").eg(10000)
    mean_load_factor: float = Float("所有进线平均负载率最低值").eg(0.5)
    max_save_charge: float = Float("理论最大优化空间 6400单位元").eg(6400)


@dataclass
class RiskCostReq(Model):
    cid: Cid


@dataclass
class RiskCostResp(Model):
    risk_data: list = List("风险").eg({"设备1": 10})
    cost_data: list = List("成本").eg({"设备1": 10})


@dataclass
class CountItemNew(Model):
    index: float = Float("指标大小").eg(0.05)
    save_charge: float = Float("节约的电费, 单位万元").eg(1)
    desc: str = Str("指标描述").eg("合格")
    space: str = Str("空间").eg("空间适合")


@dataclass
class EconomicPowerCountNewResp(Model):
    power_factor: CountItemNew = CountItemNew
    md_space: CountItemNew = CountItemNew
    pcvf: CountItemNew = CountItemNew
    power_save: CountItemNew = CountItemNew
    save_percent: float = Float("节费率").eg(0.067)
    economic_power_index: float = Float("经济用电指数").eg(90)
    avg_price: float = Float("上个月平均电价").eg(0.86)
    md_space_p: float = Float("最大需量，单位kw").eg(10000)
    mean_load_factor: float = Float("所有进线平均负载率最低值").eg(0.5)
    max_save_charge: float = Float("理论最大优化空间 6400单位元").eg(6400)