from dataclasses import dataclass

from pot_libs.sanic_api import Model
from pot_libs.sanic_api.column import Str, Float, Int, List


@dataclass
class HealthLevel(Model):
    excellent_cnt: int = Int("优秀级别的工厂个数").eg(4)
    good_cnt: int = Int("良好的工厂个数").eg(3)
    fair_cnt: int = Int("及格的工厂个数").eg(5)
    bad_cnt: int = Int("差的工厂个数").eg(1)


@dataclass
class HealthProblem(Model):
    volt_hr: int = Int("电压谐波不合格数").eg(1)
    curr_hr: int = Int("电流谐波不合格数").eg(2)
    ubl: int = Int("三相电压不平衡不合格数").eg(3)
    ibl: int = Int("三相电流不平衡不合格数").eg(4)
    volt_dev: int = Int("电压偏差不合格数").eg(5)
    freq_dev: int = Int("电流偏差不合格数").eg(6)


@dataclass
class ProxyHealthCountResp(Model):
    total_point_cnt: int = Int("总接入点数")
    unqualified_point_cnt: int = Int("不合格点数")
    health_level: HealthLevel = HealthLevel
    health_problem: HealthProblem = HealthProblem


@dataclass
class ProxyHealthPageItem(Model):
    company_name: str = Str("公司名称").eg("安电U演示工厂#1")
    point_name: str = Str("监测点").eg(78)
    health_index: float = Float("健康指数").eg(56)
    volt_hr: float = Float("电压谐波").eg(0.0136)
    stand_volt_hr: float = Float("标准电压谐波").eg(0.0136)
    curr_hr: float = Float("电流谐波").eg(0.0479)
    stand_curr_hr: float = Float("标准电流谐波").eg(0.0479)
    ubl: float = Float("三相电压不平衡").eg(0.0029)
    stand_ubl: float = Float("标准三相电压不平衡").eg(0.0029)
    ibl: float = Float("三相电流不平衡").eg(0.0033)
    stand_ibl: float = Float("标准三相电流不平衡").eg(0.0029)
    volt_dev: float = Float("电压偏差").eg(0.0732)
    stand_volt_dev: float = Float("标准电压偏差").eg(5)
    freq_dev: float = Float("频率偏差").eg(-0.0051)
    stand_freq_dev: float = Float("标准频率偏差").eg(0.1)


@dataclass
class ProxyHealthPageResp(Model):
    total: int = Int("总条数").eg(28)
    rows: list = List("一页数据").items(ProxyHealthPageItem)
