import json
import pytest
from unify_api.tests.constants_t import TOKEN, HTTP_PREFIX
from pot_libs.aiohttp_util.aiohttp_utils import AioHttpUtils


@pytest.mark.parametrize('data', [
    {
        "product": 3,
        "cid": 66
    }
])
@pytest.mark.asyncio
async def test_security_level_count(data):
    """
    代理版首页安全级别占比统计
    """
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/home-page/count-info-proxy"
            f"/security-level-count",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert all([resp_str["data"]["high_cnt"],
                resp_str["data"]["security_cnt"]])


@pytest.mark.parametrize('data', [
    {
        "product": 3,
        "cid": 66
    }
])
@pytest.mark.asyncio
async def test_alarm_percentage_count(data):
    """
    代理版首页报警分布 占比统计
    """
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/home-page/count-info-proxy"
            f"/alarm-percentage-count",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert all([resp_str["data"]["alarm_level_cnt"],
                resp_str["data"]["alarm_content_cnt"],
                resp_str["data"]["alarm_time_cnt"]])


@pytest.mark.parametrize('data', [
    {
        "product": 4,
        "cid": 66
    }
])
@pytest.mark.asyncio
async def test_proxy_map_info(data):
    """
    代理版本首页地图数据
    """
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/home-page/count-info-proxy"
            f"/proxy-map-info",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert resp_str["data"]["proxy_info"]


@pytest.mark.parametrize('data', [
    {
        "product": 4,
    }
])
@pytest.mark.asyncio
async def test_count_info_sdu(data):
    """
    识电U首页统计信息
    """
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/home-page/count-info-proxy"
            f"/count-info-sdu",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert all([resp_str["data"]["total_tenant"],
                resp_str["data"]["online_rate"],
                resp_str["data"]["total_power"],
                resp_str["data"]["total_alarm"],
                resp_str["data"]["safe_operation_days"]])


@pytest.mark.parametrize('data', [
    {
          "date_type": "day",
          "start": "2020-07-30 00:00:00",
          "end": "2020-07-30 23:59:59",
          "product": 4
    },
    {
          "date_type": "month",
          "start": "2020-07-01 00:00:00",
          "end": "2020-07-31 23:59:59",
          "product": 4
    }
])
@pytest.mark.asyncio
async def test_reg_alarm_distribution(data):
    """
    识电U首页报警分布
    """
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/home-page/count-info-proxy"
            f"/reg-alarm-distribution",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert resp_str["data"]["alarm_categories"]


@pytest.mark.parametrize('data', [
    {
          "date_type": "day",
          "start": "2021-06-01 00:00:00",
          "end": "2021-06-30 23:59:59",
          "product": 4
    },
    {
          "date_type": "month",
          "start": "2021-06-01 00:00:00",
          "end": "2021-06-30 23:59:59",
          "product": 4
    }
])
@pytest.mark.asyncio
async def test_reg_alarm_rank(data):
    """
    识电U首页报警排名
    """
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/home-page/count-info-proxy"
            f"/reg-alarm-rank",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert resp_str["data"]["position_alarm_info"]


@pytest.mark.parametrize('data', [
    {
      "product": 4,
      "cid": 90
    },
    {
        "product": 4,
        "cid": 73
    }
])
@pytest.mark.asyncio
async def test_count_info_sdu_new(data):
    """
    首页统计信息-正式版sdu
    """
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/home-page/count-info-proxy"
            f"/count-info-sdu-new",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert all([resp_str["data"]["total_tenant"],
                resp_str["data"]["online_rate"],
                resp_str["data"]["safe_day"]])



