import json
import pytest
from unify_api.tests.constants_t import TOKEN, HTTP_PREFIX
from pot_libs.aiohttp_util.aiohttp_utils import AioHttpUtils


@pytest.mark.parametrize('data', [
    {
        "cids": [42],
        "month": "2020-12",
        "status": ["减免"],
        "page_size": 10,
        "page_num": 1,
        "sort_field": "power_factor/save_charge",
        "sort_direction": "asc/desc"
    },
])
@pytest.mark.asyncio
async def test_power_factor_list(data):
    """
    知电U管理版本用电优化-功率因素-列表数据
    """
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/electric-optimization/proxy-optimization"
            f"/power-factor-list",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert len(resp_str["data"]["rows"]) == resp_str["data"]["total"]


@pytest.mark.parametrize('data', [
    {
        "cids": [118],
        "month": "2021-06",
        "status": ["减免"],
        "page_size": 10,
        "page_num": 1,
        "sort_field": "power_factor/save_charge",
        "sort_direction": "asc/desc"
    },
])
@pytest.mark.asyncio
async def test_power_factor_summary(data):
    """
    知电U管理版本用电优化-功率因素-统计数据
    """
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/electric-optimization/proxy-optimization"
            f"/power-factor-summary",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert resp_str["data"]["total_cnt"]


@pytest.mark.parametrize('data', [
    {
        "cids": [118],
        "month": "2021-06",
        "status": ["减免"],
        "page_size": 10,
        "page_num": 1,
        "sort_field": "power_factor/save_charge",
        "sort_direction": "asc/desc"
    },
])
@pytest.mark.asyncio
async def test_md_space_list(data):
    """
    知电U管理版本用电优化-需量管理-列表数据
    """
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/electric-optimization/proxy-optimization"
            f"/md-space-list",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert len(resp_str["data"]["rows"]) == resp_str["data"]["total"]


@pytest.mark.parametrize('data', [
    {
        "cids": [118],
        "month": "2021-06",
        "status": ["减免"],
        "page_size": 10,
        "page_num": 1,
        "sort_field": "power_factor/save_charge",
        "sort_direction": "asc/desc"
    },
])
@pytest.mark.asyncio
async def test_md_space_summary(data):
    """
    知电U管理版本用电优化-需量管理-统计数据
    """
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/electric-optimization/proxy-optimization"
            f"/md-space-summary",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert resp_str["data"]["total_cnt"]


@pytest.mark.parametrize('data', [
    {
        "cids": [118],
        "month": "2021-05",
        "status": ["减免"],
        "page_size": 10,
        "page_num": 1,
        "sort_field": "power_factor/save_charge",
        "sort_direction": "asc/desc"
    },
])
@pytest.mark.asyncio
async def test_power_save_list(data):
    """
    知电U管理版本用电优化-经济运行-列表数据
    """
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/electric-optimization/proxy-optimization"
            f"/power-save-list",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert len(resp_str["data"]["rows"]) == resp_str["data"]["total"]


@pytest.mark.parametrize('data', [
    {
        "cids": [118],
        "month": "2021-06",
        "status": ["减免"],
        "page_size": 10,
        "page_num": 1,
        "sort_field": "power_factor/save_charge",
        "sort_direction": "asc/desc"
    },
])
@pytest.mark.asyncio
async def test_power_save_summary(data):
    """
    知电U管理版本用电优化-经济运行-统计数据
    """
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/electric-optimization/proxy-optimization"
            f"/power-save-summary",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert resp_str["data"]["total_cnt"]


@pytest.mark.parametrize('data', [
    {
        "cids": [118],
        "month": "2021-05",
        "status": ["减免"],
        "page_size": 10,
        "page_num": 1,
        "sort_field": "power_factor/save_charge",
        "sort_direction": "asc/desc"
    },
])
@pytest.mark.asyncio
async def test_pcvf_list(data):
    """
    知电U管理版本用电优化-移峰填谷-列表数据
    """
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/electric-optimization/proxy-optimization"
            f"/pcvf-list",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert len(resp_str["data"]["rows"]) == resp_str["data"]["total"]


@pytest.mark.parametrize('data', [
    {
        "cids": [118],
        "month": "2021-06",
        "status": ["减免"],
        "page_size": 10,
        "page_num": 1,
        "sort_field": "power_factor/save_charge",
        "sort_direction": "asc/desc"
    },
])
@pytest.mark.asyncio
async def test_pcvf_summary(data):
    """
    知电U管理版本用电优化-移峰填谷-统计数据
    """
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/electric-optimization/proxy-optimization"
            f"/pcvf-summary",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert resp_str["data"]["total_cnt"]


@pytest.mark.parametrize('data', [
    {
        "cids": [44],
        "month": "2021-06",
        "status": ["减免"],
        "page_size": 10,
        "page_num": 1,
        "sort_field": "power_factor/save_charge",
        "sort_direction": "asc/desc"
    },
])
@pytest.mark.asyncio
async def test_electric_op_summary(data):
    """
    知电U管理版本-首页用电优化-统计数据
    """
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/electric-optimization/proxy-optimization"
            f"/electric-op-summary",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert all([resp_str["data"]["power_factor"],
                resp_str["data"]["md_space"],
                resp_str["data"]["pcvf"],
                resp_str["data"]["power_save"]])
