import json
import pytest
from unify_api.tests.constants_t import TOKEN, HTTP_PREFIX
from pot_libs.aiohttp_util.aiohttp_utils import AioHttpUtils


@pytest.mark.asyncio
async def test_scope_details():
    """
    波形分析
    """
    data_list = [
        {
            "wave_range": "all",
            "doc_id": "421_over_gap_i__1624334150"
        }, {
            "wave_range": "100ms",
            "doc_id": "421_over_gap_i__1624334150"
        }
    ]
    for data in data_list:
        resp_str, status = await AioHttpUtils().get(
            url=f"{HTTP_PREFIX}/unify-api/alarm-manager/details/scope-details?"
                f"wave_range={data['wave_range']}&doc_id={data['doc_id']}",
            headers={"Authorization": f"Bearer {TOKEN}"}
        )
        assert status == 200
        resp_str = json.loads(resp_str)
        assert resp_str["data"]["ctnum"] == 3
