from pot_libs.sanic_api import summary
from unify_api.modules.electric_optimization.components.optimization_cps import (
    InlineReq, PowerFactorResp, PeakCutValleyFillResp, PowerSaveResp,
    MdSpaceResp
)
from unify_api.modules.electric_optimization.service.power_index import (
    power_peakcut_service, md_space_service, power_factor_service,
    power_save_service
)


@summary("用电优化-需量管理-柱子数据")
async def post_md_space(req, body: InlineReq) -> MdSpaceResp:
    inline_id = int(body.inline_id)
    return await md_space_service(inline_id)


@summary("用电优化-功率因素-柱子数据")
async def post_power_factor(req, body: InlineReq) -> PowerFactorResp:
    inline_id = int(body.inline_id)
    return await power_factor_service(inline_id)


@summary("用电优化-移峰填谷-柱子数据")
async def post_power_peakcut(req, body: InlineReq) -> PeakCutValleyFillResp:
    inline_id = int(body.inline_id)
    return await power_peakcut_service(inline_id)


@summary("用电优化-经济运行-柱子数据")
async def post_power_save(req, body: InlineReq) -> PowerSaveResp:
    inline_id = int(body.inline_id)
    return await power_save_service(inline_id)

