# 产品map表, nginx配置host也一致
# U工助手放在安电U+项目，不能通过域名区分
from enum import Enum

from pot_libs.settings import SETTING
import os

# 跟url中host保持一致, nginx负载均衡名称
PRODUCT = {
    # "uAssistant": 0,  # u助手
    "zhiDianU": 1,  # 知电U+
    "anDianU": 2,  # 安电U+
    "AndianUManage": 3,  # 安电U+管理版
    "shiDianU": 4,  # 识电U
    "ZhidianUManage": 5,  # 知电U管理版
    "IntelligentU": 6,  # 智电U
    "RecognitionElectricNew": 7,  # 识电U新版
    "YangChen": 8,  # 扬尘生态环境管理
    "Ulock": 9,  # 运维开锁工具
    "ZhiWeiu": 10,  # 智维u
    "anShiU": 12,  # 安识u
    "qkadmin": 13,  # 清科管理后台u
}


class Product(Enum):
    """
    产品类型
    """
    ZhiDianU = 1
    AnDianU = 2
    AndianUManage = 3
    RecognitionElectric = 4
    ZhidianUManage = 5
    IntelligentU = 6  # 智电U
    RecognitionElectricNew = 7  # 识电U新版
    YangChen = 8  # 扬尘生态环境管理
    Ulock = 9  # 运维开锁工具
    AnShiU = 12  # 安识u
    qkadmin = 13  # 清科管理后台u


# 联动控制开关状态
ADIO_KEY = "adio_current"

# 联动控制，timestamp在5min内判断
LINK_CONT_EXP_TIME = 5 * 60

VOLTAGE_STANDARD = 220  # 系统额定电压
FREQ_STANDARD = 50  # 系统额定频率

REAL_EXP_TIME = 120  # 实时数据，timestamp在4小时内判断
REAL_HR_EXP_TIME = 360  # 谐波实时数据，timestamp在6分钟内判断
PTTL_REAL_EXP_TIME = 120  # 负荷实时数据，timestamp在2分钟内判断

# 电量电费index
COMPANY_15MIN_POWER = "poweriot_company_15min_power"
COMPANY_1DAY_POWER = "poweriot_company_1day_power"
POINT_15MIN_POWER = "poweriot_point_15min_power"
POINT_15MIN_INDEX = "poweriot_point_15min_index"
INLINE_15MIN_POWER = "poweriot_inline_15min_power"
INLINE_1MONTH_POWER = "poweriot_inline_1month_power"

INDEX = {
    "day": "poweriot_point_1hour_index",
    "month": "poweriot_point_1day_index",
    "year": "poweriot_point_1month_index",
}

LOCATION_1MIN_AIAO = "poweriot_location_1min_aiao"
LOCATION_15MIN_AIAO = "poweriot_location_15min_aiao"
# 温度预测, 实时预测和日前预测
LOCATION_TEMP_TREND = "poweriot_location_temp_trend"

POINT_1MIN_INDEX = "poweriot_point_1min_index"  # es一分钟
POINT_1MIN_EVENT = "poweriot_point_1min_event"  # es事件
POINT_1MIN_SCOPE = "poweriot_point_1min_scope"  # 事件录波

# 负荷分析
COMPANY_DAY_AHEAD_PRE = "poweriot_company_day_ahead_predict"  # 日前预测

# 事件设置，根据event_type表sync_device值为1，则调用后台传参给装置
EVENT_TYPE_SYNC_DEVICE = {
    "overI": 1,
    "overPR": 1,
    "overResidualCurrent": 1,
    "overTemp": 1,
    "overTempRange15min": 1,
    "overTempRange1min": 1,
    "overTempTrendDaily": 0,
    "overTempTrendQuarterly": 0,
    "overTHDI": 1,
    "overTHDU": 1,
    "overU": 1,
    "unbalanceI": 1,
    "unbalanceU": 1,
    "underPhasePF": 1,
    "underTotalPF": 1,
    "underU": 1,
}

# event_type映射
EVENT_TYPE_MAP = {
    "overI": "过流",
    "overPR": "负载率越限",
    "overResidualCurrent": "漏电流越限",
    "overTemp": "温度越限",
    "overTempRange1min": "温升1分越限",
    "overTempRange15min": "温升15分越限",
    "overTempTrendDaily": "温度日前预警",
    "overTempTrendQuarterly": "温度实时预警",
    "overTHDI": "电流总谐波有效值越限",
    "overTHDU": "电压总谐波畸变率越限",
    "overU": "过压",
    "unbalanceI": "三相电流不平衡度",
    "unbalanceU": "三相电压不平衡度",
    "underPhasePF": "某相功率因数越下限",
    "underTotalPF": "总功率因数越下限",
    "underU": "欠压",
    "under_rms_u": "电压越下限",
    "over_gap_u": "电压波动",
    "over_rms_u": "电压越上限",
    "over_gap_i": "电流波动",
    "over_rms_i": "电流越限",
}

E_TYPE_NAME_LANG = {
    "overU": {
        "zh_CN": "过压",
        "en_US": "Overvoltage",
        "de_DE": "Überspannung"
    },
    "overI": {
        "zh_CN": "过流",
        "en_US": "Overcurrent",
        "de_DE": "Überstrom"
    },
    "overPR": {
        "zh_CN": "负载率越限",
        "en_US": "Overload Limit Exceeded",
        "de_DE": "Überlastungsrate überschreitet Grenzwert"
    },
    "overResidualCurrent": {
        "zh_CN": "漏电流越限",
        "en_US": "Leakage Current Exceeded Limit",
        "de_DE": "Fehlerstrom überschreitet Grenzwert"
    },
    "overTemp": {
        "zh_CN": "温度越限",
        "en_US": "Temperature Exceeded Limit",
        "de_DE": "Temperatur überschreitet Grenzwert"
    },
    "overTempRange1min": {
        "zh_CN": "温升1分越限",
        "en_US": "Temperature Rise Exceeds Limit by 1 Degree",
        "de_DE": "Temperaturanstieg überschreitet 1-Minuten-Grenzwert"
    },
    "overTempRange15min": {
        "zh_CN": "温升15分越限",
        "en_US": "Temperature Rise Exceeds Limit by 15 Degrees",
        "de_DE": "Temperaturanstieg überschreitet 15-Minuten-Grenzwert"
    },
    "overTempTrendDaily": {
        "zh_CN": "温度日前预警",
        "en_US": "Advance Temperature Warning",
        "de_DE": "Temperaturvorwarnung für den Tag"
    },
    "overTempTrendQuarterly": {
        "zh_CN": "温度实时预警",
        "en_US": "Real-time Temperature Alert",
        "de_DE": "Echtzeit-Temperaturwarnung"
    },
    "overTHDU": {
        "zh_CN": "电压总谐波畸变率越限",
        "en_US": "Total Harmonic Distortion (THD) of Voltage Exceeds Limit",
        "de_DE": "Gesamtharmonische Spannungsverzerrung überschreitet Grenzwert"
    },
    "overTHDI": {
        "zh_CN": "电流总谐波有效值越限",
        "en_US": "Total Harmonic Distortion (THD) of Current Exceeds Limit",
        "de_DE": "Gesamtharmonische Stromverzerrung überschreitet Grenzwert"
    },
    "unbalanceU": {
        "zh_CN": "三相电压不平衡度",
        "en_US": "Three-phase Voltage Imbalance",
        "de_DE": "Dreiphasige Spannungsungleichgewicht"
    },
    "unbalanceI": {
        "zh_CN": "三相电流不平衡度",
        "en_US": "Three-phase Current Imbalance",
        "de_DE": "Dreiphasige Stromungleichgewicht"
    },
    "underPhasePF": {
        "zh_CN": "某相功率因数越下限",
        "en_US": "Power Factor of a Phase Falls Below the Lower Limit",
        "de_DE": "Unterschreitung des Leistungsfaktors einer Phase"
    },
    "underTotalPF": {
        "zh_CN": "总功率因数越下限",
        "en_US": "Total Power Factor Falls Below the Lower Limit",
        "de_DE": "Unterschreitung des Gesamtleistungsfaktors"
    },
    "underU": {
        "zh_CN": "欠压",
        "en_US": "Undervoltage",
        "de_DE": "Unterspannung"
    },
    "over_rms_u": {
        "zh_CN": "电压越上限",
        "en_US": "Voltage Above Upper Limit",
        "de_DE": "Überschreiten der Spannungsgrenze"
    },
    "under_rms_u": {
        "zh_CN": "电压越下限",
        "en_US": "Voltage Below Lower Limit",
        "de_DE": "Unterschreiten der Spannungsgrenze"
    },
    "over_gap_u": {
        "zh_CN": "电压波动",
        "en_US": "Voltage Fluctuatio",
        "de_DE": "Spannungsschwankung"
    },
    "over_gap_i": {
        "zh_CN": "电流波动",
        "en_US": "Current Fluctuation",
        "de_DE": "Stromschwankung"
    },
    "over_rms_i": {
        "zh_CN": "电流越限",
        "en_US": "Current Exceeds Limit",
        "de_DE": "Strom überschreitet Grenzwert"
    },
}

EVENT_TYPE_UNIT_MAP = {
    "overI": '%',
    "overPR": '%',
    "overResidualCurrent": 'mA',
    "overTemp": '°C',
    "overTempRange1min": '°C',
    "overTempRange15min": '°C',
    "overTempTrendDaily": '°C',
    "overTempTrendQuarterly": '°C',
    "overTHDI": 'A',
    "overTHDU": '%',
    "overU": '%',
    "unbalanceI": '%',
    "unbalanceU": '%',
    "underPhasePF": '',
    "underTotalPF": '',
    "underU": '%',
}

# 报警记录温度趋势可跳转type
TEMP_SCOPE_URL_TYPE = ["overTempTrendDaily", "overTempTrendQuarterly"]

SLOTS = {
    "day": [
        "00:00",
        "01:00",
        "02:00",
        "03:00",
        "04:00",
        "05:00",
        "06:00",
        "07:00",
        "08:00",
        "09:00",
        "10:00",
        "11:00",
        "12:00",
        "13:00",
        "14:00",
        "15:00",
        "16:00",
        "17:00",
        "18:00",
        "19:00",
        "20:00",
        "21:00",
        "22:00",
        "23:00",
    ]
}

SLOTS_15MIN = ["00:00", "00:15", "00:30", "00:45", "01:00", "01:15", "01:30",
               "01:45", "02:00", "02:15", "02:30", "02:45", "03:00", "03:15",
               "03:30", "03:45", "04:00", "04:15", "04:30", "04:45", "05:00",
               "05:15", "05:30", "05:45", "06:00", "06:15", "06:30", "06:45",
               "07:00", "07:15", "07:30", "07:45", "08:00", "08:15", "08:30",
               "08:45", "09:00", "09:15", "09:30", "09:45", "10:00", "10:15",
               "10:30", "10:45", "11:00", "11:15", "11:30", "11:45", "12:00",
               "12:15", "12:30", "12:45", "13:00", "13:15", "13:30", "13:45",
               "14:00", "14:15", "14:30", "14:45", "15:00", "15:15", "15:30",
               "15:45", "16:00", "16:15", "16:30", "16:45", "17:00", "17:15",
               "17:30", "17:45", "18:00", "18:15", "18:30", "18:45", "19:00",
               "19:15", "19:30", "19:45", "20:00", "20:15", "20:30", "20:45",
               "21:00", "21:15", "21:30", "21:45", "22:00", "22:15", "22:30",
               "22:45", "23:00", "23:15", "23:30", "23:45"]

ADD_ELE_PRICE = {0.89: 0.5, 0.88: 1.0, 0.87: 1.5, 0.86: 2.0, 0.85: 2.5,
                 0.84: 3.0, 0.83: 3.5, 0.82: 4.0, 0.81: 4.5, 0.8: 5.0,
                 0.79: 5.5, 0.78: 6.0, 0.77: 6.5, 0.76: 7.0, 0.75: 7.5,
                 0.74: 8.0, 0.73: 8.5, 0.72: 9.0, 0.71: 9.5, 0.7: 10.0,
                 0.69: 11.0, 0.68: 12.0, 0.67: 13.0, 0.66: 14.0, 0.65: 15.0,
                 0.64: 17, 0.63: 19, 0.62: 21, 0.61: 23, 0.6: 25, 0.59: 27,
                 0.58: 29, 0.57: 31, 0.56: 33, 0.55: 35, 0.54: 37, 0.53: 39,
                 0.52: 41, 0.51: 43, 0.5: 45, 0.49: 47, 0.48: 49, 0.47: 51,
                 0.46: 53, 0.45: 55, 0.44: 57, 0.43: 59, 0.42: 61, 0.41: 63,
                 0.4: 65, 0.39: 67, 0.38: 69, 0.37: 71, 0.36: 73, 0.35: 75,
                 0.34: 77, 0.33: 79, 0.32: 81, 0.31: 83, 0.3: 85, 0.29: 87,
                 0.28: 89, 0.27: 91, 0.26: 93, 0.25: 95, 0.24: 97, 0.23: 99,
                 0.22: 101, 0.21: 103, 0.2: 105, 0.19: 107,
                 0.18: 109, 0.17: 111, 0.16: 113, 0.15: 115, 0.14: 117,
                 0.13: 119, 0.12: 121, 0.11: 123, 0.1: 125, 0.09: 127,
                 0.08: 129, 0.07: 131, 0.06: 133, 0.05: 135, 0.04: 137,
                 0.03: 139, 0.02: 141, 0.01: 143, 0: 145}

# U助手sid白名单
U_WHITE_LIST_SID = ["ctnum2", "ctnum3"]


class Importance(Enum):
    """
    事件重要性(级别)
    """
    First = 1
    Second = 2
    Third = 3


# es 查询总数如果大于这个数量那么，只返回10000条, 防止出现"Result window is too large"
# PRD文档, 最多为500条
ES_TOTAL_LIMIT = 2000

# 电气安全微信小程序，渠道版
WECHAT_ELECSAFE_APP_ID = "wx9c1380597780188f"
WECHAT_ELECSAFE_SECRET_KEY = "acb2bd0a4c7771942a549b2fbd6697cd"
# 电气安全微信小程序，工厂版
WECHAT_ELECSAFE_FACTORY_APP_ID = "wx4a5647cccd51bd57"
WECHAT_ELECSAFE_FACTORY_SECRET_KEY = "a9bcd0b3d1df1b298e7e5aff004b292a"

# 知电U+工厂版
WECHAT_ZDU_FACTORY_APP_ID = "wx65190fed48cbd67e"
WECHAT_ZDU_FACTORY_SECRET_KEY = "f8791e4e6b490b50849a78d95971adea"

WECHAT_U_ASSISTANT_APP_ID = "wxfebed5f3e46ac0d5"
WECHAT_U_ASSISTANT_SECRET_KEY = "ce7eb45925d10d6601ec1aab67d581c5"

# 装置升级目录
# http://www.dev.uplus.soejh.com/uplus/unify-api/upgrade/device/download
DEVICE_UPGRADED_FILE = "~/upgraded/upgrade.bin"

# 微信开发平台,web扫码登录
# app_id: wxf23bec7698a6e4d4   https://www.dev.andianu.soejh.com/
# secret_key:3169cd62466d14c8ce3f7b1d4059f0e2
OPEN_APP_ID = {
    "zhiDianU": "wx9680a7468010c4fa",  # https://www.upower.soejh.com
    "anDianU": "wx6dafd5aa89e9adb8",  # https://www.elecsafe.soejh.com/
}
OPEN_SECRET_KEY = {
    "zhiDianU": "938c53e85d06e47ae740383841ee7a2c",
    "anDianU": "625e56f231bffc20e3117b8761ab82ff",
}


class ExtendModule(Enum):
    """
    扩展模块权限枚举
    """

    LinkControl = 0
    AlgorithmResultNormal = 1  # 粗略结果信息
    AlgorithmResultDetail = 2  # 识电Ｕ算法更具体的信息，公司内部人才有


# U+云的产品配置
PRODUCT_INFOS = {
    1: {
        "name": "知电U+",
        "url": SETTING.zhidianu_url,
        "img_url": f"{SETTING.download_img_url}/image/zhidianu.png",
        "info": "聚焦电力画像，洞悉用电规律，优化用电行为。",
        "sort_num": 10
    },
    2: {
        "name": "安电U+",
        "url": SETTING.andianu_url,
        "img_url": f"{SETTING.download_img_url}/image/andianu.png",
        "info": "电气安全卫士，拒绝电气事故，助力安全可靠。",
        "sort_num": 20
    },
    3: {
        "name": "安电U+——管理版",
        "url": SETTING.m_andianu_url,
        "img_url": f"{SETTING.download_img_url}/image/m-andianu.png",
        "info": "掌握项目安全状态，量化管理用电风险，降本增效有据可依。",
        "sort_num": 42
    },
    4: {
        "name": "识电U+",
        "url": SETTING.shidianu_url,
        "img_url": f"{SETTING.download_img_url}/image/shidianu.png",
        "info": "识别违规用电，洞察用电风险，助力事前预防，防患于未然。",
        "sort_num": 30
    },
    5: {
        "name": "知电U+——管理版",
        "url": SETTING.m_zhidianu_url,
        "img_url": f"{SETTING.download_img_url}/image/m-zhidianu.png",
        "info": "了解电力用户，洞悉用户特征，挖掘需求、服务业务。",
        "sort_num": 43
    },
    6: {
        "name": "智电U+",
        "url": SETTING.zdu_url,
        "img_url": f"{SETTING.download_img_url}/image/zdu.png",
        "info": "智能电管家，助力安全用电、高效用电、经济用电、绿色用电。",
        "sort_num": 40
    },
    7: {
        "name": "综合能源低碳数字化园区指挥管理平台",
        "url": SETTING.comp_energy_url,
        "img_url": f"{SETTING.download_img_url}/image/new-shidianu.png",
        "sort_num": 41
    },
    8: {
        "name": "扬尘生态环境管理",
        "url": SETTING.dust_url,
        "img_url": f"{SETTING.download_img_url}/image/dust.png",
        "info": "实时掌握空气质量，科学管理降尘措施，助力绿色文明施工。",
        "sort_num": 60
    },
    10: {
        "name": "智维U+",
        "url": SETTING.zhiweiu_url,
        "img_url": f"{SETTING.download_img_url}/image/zhiweiu.png",
        "info": "快速掌握问题、反馈问题、处理问题，助力运维闭环管理。",
        "sort_num": 50
    },
    12: {
        "name": "安识U+",
        "url": SETTING.anshiu_url,
        "img_url": f"{SETTING.download_img_url}/image/anshiu.png",
        "info": "电气安全精细监控，用电风险瞬间捕捉，电气事故无所遁形。",
        "sort_num": 44
    },
    13: {
        "name": "清科优能官方网站管理平台",
        "url": "https://www.ucyber.cn/qkadmin/",
        "img_url": "https://cdn.ucyber.cn/images/ucloud/qkadmin.png",
        "info": "文章管理、SEO优化、数据管理",
        "sort_num": 99
    },
    14: {
        "name": "电气安全运维",
        "url": SETTING.ele_safe_opt_url,
        "img_url": f"{SETTING.download_img_url}/image/anshiu.png",
        "info": "",
        "sort_num": 31
    },
    15: {
        "name": "能碳资源评估",
        "url": SETTING.energy_carbon_url,
        "img_url": f"{SETTING.download_img_url}/image/anshiu.png",
        "info": "",
        "sort_num": 32
    },
    16: {
        "name": "碳排双控能源管理",
        "url": SETTING.carbon_emis_url,
        "img_url": f"{SETTING.download_img_url}/image/anshiu.png",
        "info": "",
        "sort_num": 33
    },
    17: {
        "name": "微电网运行管理",
        "url": SETTING.microgrid_opt_url,
        "img_url": f"{SETTING.download_img_url}/image/anshiu.png",
        "info": "",
        "sort_num": 34
    },
    18: {
        "name": "虚拟电厂运营管理",
        "url": SETTING.vpp_uside_gd_url,
        "img_url": f"{SETTING.download_img_url}/image/anshiu.png",
        "info": "",
        "sort_num": 35
    },
    19: {
        "name": "虚拟电厂用户侧管理平台",
        "url": SETTING.vpp_uside_sz_url,
        "img_url": f"{SETTING.download_img_url}/image/anshiu.png",
        "info": "",
        "sort_num": 36
    },
    20: {
        "name": "虚拟电厂负荷聚合商管理平台",
        "url": SETTING.vpp_agg_url,
        "img_url": f"{SETTING.download_img_url}/image/anshiu.png",
        "info": "",
        "sort_num": 37
    }

}
# 项目目录/home/ubuntu/data/code/unify_api
BASE_PRJ_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))

# 报警设置-漏电流设置, 志鹏user_id可设置

# RESIDUAL_CURRENT_OP = [125]
RESIDUAL_CURRENT_OP = [125, 52, 100536]

# 用户侧储能
USER_SIDE = {
    "cell_price": 2000,
    "pcs_price": 300,
    "other_ttl_charge": 0,
    "pcs_efficiency": 95,
    "bat_efficiency": 95,
    "decay_rate": 5.0,
    "dod": 90,
    "year_use_days": 330,
    "charge_c_rate": 0.8
}
ENERGY_INVESTMENT_ESS = 0  # userside energy store
ENERGY_INVESTMENT_PV = 1  # distributed photovoltaic
INLINE_15MIN_POWER_ESINDEX = "poweriot_inline_15min_power"
INLINE_1DAY_POWER_ESINDEX = "poweriot_inline_1day_power"
# 分布式光伏
DEFAULT_PV_PARAMS = {
    # "install_space": 200,
    "self_use_ratio": 0.7,
    "rmb_per_wp": 7.5,
    "sel_use_per_kwh": 0.8,
    "self_use_price_discout": 10,
    "first_install_subsidy": 0,
    "local_subsidy": 0.25,
    "local_subsidy_year": 5,
}

# 碳排放系数
CO2_N = 0.754

# 当用户节约1kWh电量时，减少碳排放0.2047kg；减少二氧化碳排放0.751kg
REDUCE_CO2 = 0.751

# 识电U报警类型列表
SDU_ALARM_LIST = ["power_quality_low",  # 电能质量偏低--III级报警
                  "ele_overload",  # 线路过载--II级报警
                  "illegal_ele_app",  # 违规电器接入--I级报警
                  # "high_power_app",  # 大功率电器接入, 新版不展示统计
                  # "ele_car_battery"  # 电动车电池, 归为违规电器
                  ]

# sdu I级,II级报警
SDU_ONE_TWO_GRADE_ALARM = ["ele_overload", "illegal_ele_app"]

SDU_EVENT_TYPE_MAP = {
    "ele_car_battery": "电动车电池",
    "ele_overload": "线路过载",
    "high_power_app": "大功率电器",
    "illegal_ele_app": "违规电器",
    "power_quality_low": "电能质量偏低",
    "normal_app": "正常电器"
}

# tsp信息阈值
PM2_5 = 75
PM10 = 150
TSP = 300

# 降尘开启状态
DUST_STATE = {
    0: "关闭",
    1: "开启"
}

# 监测点层级类型
POINT_LEVEL_MAP = {
    1: "inline",
    2: "transformer",
    3: "feeder",
    4: "power_dist",
    5: "device"
}

# 电压偏差大于等于7%时, 某项电压表红
U_THRESHOLD = 0.07
# 功率因数小于0.9
COSTTL_THRESHOLD = 0.9
# 负载率大于等于90%时
LF_THRESHOLD = 0.9

# 电压总谐波畸变大于等于5%时, 某相电压变为红色
THDU_THRESHOLD = 0.05
# 三相不平衡度大于等于2%
BL_THRESHOLD = 0.02
# 电流谐波畸变
THDI_THRESHOLD = 0.15

# 智维u, 文件上传路径
INSTALL_SHEET = "filedata/zhiweiu/install-sheet"
DOWNLOAD_ORDER = "filedata/zhiweiu/order"

SMS_LOGIN_TEMPLATE = "SMS_222195119"
SMS_SIGN_NAME = "清科优能"

TDENGINE_CHILD_SUBFIX_LIST = {
    "db_appliance": "app",
    "db_soe": "soe",
    "db_scope": "scp",
    "db_adio": "adi",
    "db_electric": "ele",
}

# 温度
TEMPERATURE_MAP = {
    "overTemp",
    "overTempRange1min",
    "overTempRange15min",
    "overTempTrendDaily",
    "overTempTrendQuarterly"
}
# 漏电流
RESIDUAL_CURRENT_MAP = {
    "overResidualCurrent"
}

# 电参数
ELECTRIC_PARAM_MAP = {
    "overTHDI",  # 电流总谐波有效值越限
    "overTHDU",  # 电压总谐波畸变率越限
    "overU",  # 过压
    "underU",  # 欠压
    "overI",
    "underPhasePF",  # 单相功率因数越下限
    "underTotalPF",  # 总功率因数越下限
    "unbalanceI",  # 三相电流不平衡度
    "unbalanceU",  # 三相电压不平衡度
    "overPR"
}

CST = "Asia/Shanghai"

TD_TBL_POSTFIX = {"electric": "ele", "soe": "soe", "scope": "scp",
                  "adio": "adi", "appliance": "app", "log": "log",
                  "workshop": "wks", "water": "wat", "tsp": "tsp",
                  "ws": "ws"}

S030_TOPIC = ["electric", "soe", "scope", "adio", "scope", "appliance",
              "workshop", "log"]
WG_TOPIC = ["tsp", "water", "water_bromake", "ws"]

OSS_NEWS = "filedata/official_web/news_info"

E_TYPE_MSG_LANG = {
    "power_quality_low": {
        "en_US": "The power quality is low, and there may be substandard electrical appliances present",
        "de_DE": "Die Stromqualität ist niedrig, und es könnten nicht normgerechte elektrische Geräte vorhanden sein"
    },
    "illegal_ele_app": {
        "en_US": "There is an unauthorized appliance connected and in use, suspected to be {appliance}",
        "de_DE": "Es ist ein nicht autorisiertes Gerät angeschlossen und in Betrieb, vermutlich {appliance}"
    },
    "ele_overload": {
        "en_US": "The line load rate has exceeded 80%, with the highest reaching {max}%",
        "de_DE": "Die Leitungsbelastung hat 80% überschritten, wobei der Höchstwert {max}% erreicht"
    },
    "overI": {
        "en_US": "The current on phase {phase} has been exceeding the rated current by {threshold}% for {duration} seconds, reaching a maximum of {max}A",
        "de_DE": "Der Strom in Phase {phase} hat den Nennwert um {threshold}% für {duration} Sekunden überschritten und erreicht ein Maximum von {max}A"
    },
    "overU": {
        "en_US": "The voltage on the {branch} has been exceeding the rated voltage by {threshold}% for {duration} seconds, reaching a maximum of {max}V",
        "de_DE": "Die Spannung im {branch} hat den Nennwert um {threshold}% für {duration} Sekunden überschritten und erreicht ein Maximum von {max}V"
    },
    "overPR": {
        "en_US": "Load rate exceeds {threshold}%, reaching {cur}%",
        "de_DE": "Die Lastquote überschreitet {threshold}%, erreicht {cur}%"
    },
    "overResidualCurrent": {
        "en_US": "The leakage current has exceeded {threshold} mA, reaching {cur} mA",
        "de_DE": "Der Leckstrom hat {threshold} mA überschritten und erreicht {cur} mA"
    },

    "overTemp": {
        "en_US": "The temperature has exceeded {threshold}°C, reaching {cur}°C",
        "de_DE": "Die Temperatur hat {threshold}°C überschritten und erreicht {cur}°C"
    },
    "overTempRange15min": {
        "en_US": "The temperature rise exceeds {threshold}°C within 15 minutes, reaching {cur}°C",
        "de_DE": "Der Temperaturanstieg überschreitet innerhalb von 15 Minuten den Schwellenwert von {threshold}°C und erreicht {cur}°C"
    },
    "overTempRange1min": {
        "en_US": "The temperature rise within 1 minute has exceeded {threshold}°C, reaching {cur}°C",
        "de_DE": "Der Temperaturanstieg innerhalb von 1 Minute hat {threshold}°C überschritten und erreicht {cur}°C"
    },
    "overTempTrendDaily": {
        "en_US": "The temperature forecast for today predicts that the temperature at {time_str} may exceed {threshold}°C, reaching {cur}°C",
        "de_DE": "Die Temperaturvorhersage für heute prognostiziert, dass die Temperatur um {time_str} den Schwellenwert von {threshold}°C überschreiten und {cur}°C erreichen könnte."
    },
    "overTempTrendQuarterly": {
        "en_US": "The real-time temperature forecast for today suggests that the temperature at {time_str} may exceed {threshold}°C, reaching {cur}°C",
        "de_DE": "Die Echtzeit-Temperaturvorhersage für heute deutet darauf hin, dass die Temperatur um {time_str} den Schwellenwert von {threshold}°C überschreiten und {cur}°C erreichen könnte"
    },
    "overTHDI": {
        "en_US": "The total harmonic distortion (THD) of the {phase}-phase current exceeds the limit of {threshold}A, reaching {cur}A",
        "de_DE": "The total harmonic distortion (THD) of the {phase}-phase current exceeds the limit of {threshold}A, reaching {cur}A"
    },

    "overTHDU": {
        "en_US": "The total harmonic distortion (THD) of the voltage in phase {phase} has exceeded the limit of {threshold}%, reaching {cur}%",
        "de_DE": "Die Gesamtoberschwingungsverzerrung (THD) der Spannung in Phase {phase} hat den Grenzwert von {threshold}%  überschritten und erreicht {cur}%"
    },

    "unbalanceI": {
        "en_US": "The three-phase current unbalance has been sustained for {duration} seconds exceeding {threshold}%, with the highest reaching {max}%",
        "de_DE": "Die Unsymmetrie des Dreiphasenstroms dauert seit {duration} Sekunden und überschreitet {threshold}%, wobei das Maximum {max}% erreicht"
    },
    "unbalanceU": {
        "en_US": "The three-phase voltage unbalance has been exceeding {threshold}% for {duration} seconds, with the highest reaching {max}",
        "de_DE": "Die Dreiphasenspannungsunsymmetrie überschreitet seit {duration} Sekunden {threshold}%, wobei der Höchstwert {max}% erreicht"
    },
    "under_rms_u": {
        "en_US": "",
        "de_DE": ""
    },
    "underPhasePF": {
        "en_US": "The power factor of phase {phase} has been below {threshold} for {duration} seconds, reaching a minimum of {min}",
        "de_DE": "Der Leistungsfaktor der Phase {phase} liegt seit {duration} Sekunden unter {threshold} und erreicht ein Minimum von {min}."
    },

    "underTotalPF": {
        "en_US": "The three-phase total power factor has been below {threshold} for {duration} seconds, reaching a minimum of {min}",
        "de_DE": "Der Gesamtleistungsfaktor der Dreiphasenstromversorgung liegt seit {duration} Sekunden unter {threshold} und erreicht ein Minimum von {min}."
    },

    "underU": {
        "en_US": "The voltage on branch {branch} has been below the rated voltage by {threshold}% for {duration} seconds, reaching a minimum of {min}V",
        "de_DE": "Die Spannung im {branch} liegt seit {duration} Sekunden um {threshold}% unter dem Nennwert und erreicht ein Minimum von {min}V"
    },
    "over_gap_cur": {
        "en_US": "",
        "de_DE": ""
    },
    "over_gap_i": {
        "en_US": "",
        "de_DE": ""
    },
    "over_gap_pttl": {
        "en_US": "",
        "de_DE": ""
    },

    "over_gap_u": {
        "en_US": "",
        "de_DE": ""
    },
    "over_res_cur": {
        "en_US": "",
        "de_DE": ""
    },
    "over_rms_i": {
        "en_US": "",
        "de_DE": ""
    },
    "over_rms_pttl": {
        "en_US": "",
        "de_DE": ""
    },
    "over_rms_u": {
        "en_US": "",
        "de_DE": ""
    },
}

PHASE_LINE_LANG = {
    "A相": {
        "en_US": "Phase A",
        "de_DE": "Phase A"
    },
    "B相": {
        "en_US": "Phase B",
        "de_DE": "Phase B"
    },
    "C相": {
        "en_US": "Phase C",
        "de_DE": "Phase C"
    },
    "N线": {
        "en_US": "Neutral Line",
        "de_DE": "N-Leitung"
    },
    "漏电流": {
        "en_US": "Leakage current",
        "de_DE": "Elektrizität"
    },
}

PRODUCT_NAME = {
    1: {
        "zh_CN": "知电U+",
        "en_US": "Master Electricity Use U+",
        "de_DE": "ZhiDian U+"
    },
    2: {
        "zh_CN": "安电U+",
        "en_US": "Safe Electricity Use U+",
        "de_DE": "Andean U+"
    },
    3: {
        "zh_CN": "安电U+——管理版",
        "en_US": "Safe Electricity Use U+ —— Management Edition",
        "de_DE": "Andean U+ Management-Version"
    },
    4: {
        "zh_CN": "识电U+",
        "en_US": "Recognize Electricity Use U+",
        "de_DE": "ShiDian U+"
    },
    5: {
        "zh_CN": "知电U+——管理版",
        "en_US": "Master Electricity Use U+ —— Management Edition",
        "de_DE": "ZhiDian U+ Management-Version"
    },
    6: {
        "zh_CN": "智电U+",
        "en_US": "Smart Electricity Use U+",
        "de_DE": "ZhiDian U+"
    },
    7: {
        "zh_CN": "综合能源低碳数字化园区指挥管理平台",
        "en_US": "Integrated Energy Low-Carbon Digital Park Command and Management Platform",
        "de_DE": "Integrierte Energie-Niederigkohlenstoff-Digitalpark-Management-Plattform"
    },
    8: {
        "zh_CN": "扬尘生态环境管理",
        "en_US": "Dust Control Environmental Management",
        "de_DE": "Staub- und Ökomanagement"
    },
    10: {
        "zh_CN": "智维U+",
        "en_US": "Smart Operation and Maintenance U+",
        "de_DE": "ZhiWei U+"
    },
    12: {
        "zh_CN": "安识U+",
        "en_US": "Safety Identification U+",
        "de_DE": "AnShi U+"
    },
    13: {
        "zh_CN": "清科优能官方网站管理平台",
        "en_US": "Amber Optimal Official Website Management Platform",
        "de_DE": "offizielle Webseit-Management-Plattform von Qingke"
    },
    14: {
        "zh_CN": "电气安全运维",
        "en_US": "Electrical safety operation and maintenance",
        "de_DE": "Betrieb und Wartung der elektrischen Sicherheit"
    },
    15: {
        "zh_CN": "能碳资源评估",
        "en_US": "Energy and carbon resource assessment",
        "de_DE": "Energie- und Kohlenstoffressourcenbewertung"
    },
    16: {
        "zh_CN": "碳排双控能源管理",
        "en_US": "Carbon emission management",
        "de_DE": "Verwaltung der Kohlenstoffemissionen"
    },
    17: {
        "zh_CN": "微电网运行管理",
        "en_US": "Operation management of microgrids",
        "de_DE": "Betrieb und Management von Mikronetzen"
    },
    18: {
        "zh_CN": "虚拟电厂运营管理",
        "en_US": "Operation and management of virtual power plants",
        "de_DE": "Betrieb und Verwaltung von virtuellen Kraftwerken"
    },
    19: {
        "zh_CN": "虚拟电厂用户侧管理平台",
        "en_US": "Virtual power plant user-side management platform",
        "de_DE": "Benutzerseitige Verwaltungsplattform für virtuelle Kraftwerke"
    },
    20: {
        "zh_CN": "虚拟电厂负荷聚合商管理平台",
        "en_US": "Virtual power plant load aggregator management platform",
        "de_DE": "Plattform zur Verwaltung virtueller Kraftwerkslastaggregatoren"
    },

}

LOG_IN_TIPS = {
    "err_uname_pwd": {
        "zh_CN": "用户名或密码错误",
        "en_US": "Username or password is incorrect",
        "de_DE": "Benutzername oder Passwort falsch"
    },
    "err_vfy_code": {
        "zh_CN": "验证码错误",
        "en_US": "Verification code is incorrect",
        "de_DE": "Bestätigungscode ist falsch"
    },
    "phone_bound": {
        "zh_CN": "该手机号已被绑定",
        "en_US": "This phone number has already been bound",
        "de_DE": "Diese Telefonnummer is bereits verknüpft"
    },
    "err_phone_fmt": {
        "zh_CN": "手机号码格式错误",
        "en_US": "The phone number format is incorrect",
        "de_DE": "Ungültiges Format der Telefonnummer"
    },
    "vfy_code_inconst": {
        "zh_CN": "验证码不一致",
        "en_US": "The verification code is inconsistent",
        "de_DE": "Bestätigungscode stimmt nicht überein"
    },
    "send_suc": {
        "zh_CN": "发送成功",
        "en_US": "Sending successful",
        "de_DE": "Erfolgreic gesendet"
    },
    "msg_send_lim": {
        "zh_CN": "您今日发送短信次数已用完",
        "en_US": "Your daily limit for sending text messages has been reached",
        "de_DE": "Sie haben das täglich SMS- Limit erreicht "
    },
    "vfy_code_freq": {
        "zh_CN": "请求验证码过于频繁",
        "en_US": "The request for a verification code is too frequent.",
        "de_DE": "Bestätigungscode zu oft angefordert"
    },
    "vfy_code_freq_hr": {
        "zh_CN": "请求验证码过于频繁，请1小时后重新发送",
        "en_US": "Please wait for an hour before requesting the verification code again due to excessive requests",
        "de_DE": "Bestätigungscode zu oft angefordert, bitte nach 1 Stunde erneut senden"
    },
    "vfy_code_freq_min": {
        "zh_CN": "请求验证码过于频繁，请1分钟后重新发送",
        "en_US": "Please wait for 1 minute before requesting the verification code again due to the high frequency of requests",
        "de_DE": "Bestätigungscode zu oft angefordert, bitte nach 1 Minute erneut senden"
    },
    "vfy_code_send_fail": {
        "zh_CN": "验证码发送失败",
        "en_US": "The verification code failed to send",
        "de_DE": "Senden des Bestätigungscode fehlgeschlagen"
    },
    "phone_not_invalid": {
        "zh_CN": "手机号码不合法",
        "en_US": "The phone number is invalid",
        "de_DE": "Ungünstige Telefonnummer"
    },
    "passwd_inconst": {
        "zh_CN": "两次密码不一致",
        "en_US": "The two passwords do not match",
        "de_DE": "Die zwei Passwörter stimmt nicht überein"
    },
    "phone_registered": {
        "zh_CN": "该手机号已注册",
        "en_US": "This phone number has already been registered",
        "de_DE": "Diese Telefonnummer ist bereits registriert"
    },
    "user_save_suc": {
        "zh_CN": "保存用户信息成功",
        "en_US": "User information saved successfully",
        "de_DE": "Benutzerdaten erfolgreich gespeichert"
    },
    "unbind_wechat_suc": {
        "zh_CN": "解除微信绑定成功",
        "en_US": "Unbinding WeChat has been successful",
        "de_DE": "WeChat- binding erfolgreich gelöst"
    },
    "wechat_bind_suc": {
        "zh_CN": "微信绑定成功",
        "en_US": "WeChat binding successful",
        "de_DE": "WeChat-Bindung erfolgreich"
    },
    "wechat_bind_fail": {
        "zh_CN": "微信绑定失败",
        "en_US": "WeChat binding failed",
        "de_DE": "Die WeChat-Bindung ist fehlgeschlagen"
    },
    "wechat_bound": {
        "zh_CN": "该微信号已经被绑定",
        "en_US": "This WeChat ID has been bound",
        "de_DE": "Diese WeChat-ID wurde gebunden"
    },
    "phone_no_usable": {
        "zh_CN": "该手机号码可用",
        "en_US": "The phone number is available",
        "de_DE": "Die Handynummer ist verfügbar"
    },
    "phone_no_reg_dea": {
        "zh_CN": "手机号未注册或已注销",
        "en_US": "The phone number is not registered or has been deactivated",
        "de_DE": "Telefonnummer nicht registriert oder abgemeldet"
    },
    "phone_not_reg": {
        "zh_CN": "手机号未注册",
        "en_US": "The phone number is not registered",
        "de_DE": "Telefonnummer nicht registriert"
    },
    "succeed": {
        "zh_CN": "成功",
        "en_US": "succeed",
        "de_DE": "Erfolg"
    },
    "fail": {
        "zh_CN": "失败",
        "en_US": "fail",
        "de_DE": "scheitern"
    },
    "direct_info_page": {
        "zh_CN": "跳转填写页面",
        "en_US": "Skip fill page",
        "de_DE": "Springen Sie zur Seite zum Ausfüllen von Informationen"
    },
    "miss_req_param": {
        "zh_CN": "缺少必传参数",
        "en_US": "Missing required parameters",
        "de_DE": "Erforderliche Parameter fehlen"
    },
    "update_suc": {
        "zh_CN": "修改成功",
        "en_US": "Successfully modified",
        "de_DE": "Erfolgreich geändert"
    },
    "vfy_pass": {
        "zh_CN": "验证通过",
        "en_US": "Verification passed",
        "de_DE": "Verifizierung bestanden"
    },
    "miss_param": {
        "zh_CN": "缺少参数",
        "en_US": "Missing parameters",
        "de_DE": "Fehlende Parameter"
    },
    "logout_suc": {
        "zh_CN": "注销成功",
        "en_US": "Logout successful",
        "de_DE": "Abmeldung erfolgreich"
    },
    "account_no_auth": {
        "zh_CN": "当前账号无权限，请联系管理人员",
        "en_US": "The current account does not have permission, please contact the administrator",
        "de_DE": "Für das aktuelle Konto ist keine Berechtigung vorhanden. Bitte wenden Sie sich an den Administrator"
    },

}
