import json
import pytest
from unify_api.tests.constants_t import post_request
from unify_api.tests.constants_t import TOKEN, HTTP_PREFIX
from pot_libs.aiohttp_util.aiohttp_utils import AioHttpUtils


@pytest.mark.parametrize('data', [
    {
      "cid": 44,
      "page_size": 10,
      "page_num": 1
    }
])
@pytest.mark.asyncio
async def test_hardware_info_list(data):
    """
    获取硬件信息
    """
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/product-info/hardware-info"
            f"/hardware-info-list",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert len(resp_str["data"]["rows"]) == resp_str["data"]["total"]


@pytest.mark.parametrize('data', [
    {"cid": 44},
    {"cid": 90},
])
@pytest.mark.asyncio
async def test_hardware_info_count(data):
    """
    硬件统计信息
    """
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/product-info/hardware-info"
            f"/hardware-info-count",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert resp_str["data"]["installed_number"]


#  安装信息-识电u
class TestHardwareInfoSdu(object):
    url = "/unify-api/product-info/hardware-info/hardware-info-sdu"

    @pytest.mark.parametrize('data', [{"cid": 44}, {"cid": 90}])
    @pytest.mark.asyncio
    async def test_hardware_info_sdu(self, data):
        resp_str, status = await post_request(self.url, data)
        assert status == 200
        resp_dict = json.loads(resp_str)
        data = resp_dict["data"]
        assert all([data["point_num"], data["device_num"]])

    @pytest.mark.parametrize('data', [{"cid": -100}, {"cid": 1000}])
    @pytest.mark.asyncio
    async def test_hardware_info_sdu_cid_error(self, data):
        resp_str, status = await post_request(self.url, data)
        assert status == 200
        resp_dict = json.loads(resp_str)
        assert resp_dict["data"]["point_num"] == 0


#  管理版-关于我们-统计
class TestHardwareInfoManagement(object):
    url = "/unify-api/product-info/hardware-info/hardware-info-management"

    @pytest.mark.parametrize('data', [{
            "proxy_id": 1, "product": 3, "userid": 88}, {
            "proxy_id": 1, "product": 5, "userid": 88}])
    @pytest.mark.asyncio
    async def test_hardware_info_management(self, data):
        resp_str, status = await post_request(self.url, data)
        assert status == 200
        resp_dict = json.loads(resp_str)
        data = resp_dict["data"]
        assert all([data["project_count"], data["detection_point_count"]])

    @pytest.mark.parametrize('data', [{
            "proxy_id": 0, "product": 3, "userid": 88}, {
            "proxy_id": 1, "product": 50, "userid": 88}])
    @pytest.mark.asyncio
    async def test_hardware_info_sdu_cid_error(self, data):
        resp_str, status = await post_request(self.url, data)
        assert status == 200
        resp_dict = json.loads(resp_str)
        assert resp_dict["data"]["project_count"] == 0


@pytest.mark.parametrize('data', [
    {
        "cid": 44,
        "page_size": 10,
        "page_num": 1
    },
])
@pytest.mark.asyncio
async def test_hardware_list_sdu(data):
    """
    安装信息分页数据-识电u
    """
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/product-info/hardware-info"
            f"/hardware-info-sdu",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert all([resp_str["data"]["point_num"], resp_str["data"]["device_num"]])


#  管理版-关于我们-分页
class TestHardwareInfoListManagement(object):
    url = "/unify-api/product-info/hardware-info/hardware-info-list-management"

    @pytest.mark.parametrize('data', [{
        "proxy_id": 1, "product": 3, "userid": 88, "page_size": 10,
        "page_num": 1}, {"proxy_id": 1, "product": 5, "userid": 88,
                         "page_size": 20, "page_num": 1}])
    @pytest.mark.asyncio
    async def test_hardware_info_list_management(self, data):
        resp_str, status = await post_request(self.url, data)
        assert status == 200
        resp_dict = json.loads(resp_str)
        assert all([resp_dict["data"]["rows"], resp_dict["data"]["total"]])

    @pytest.mark.parametrize('data', [{
        "proxy_id": -5, "product": 30, "userid": 88, "page_size": 10,
        "page_num": 1}, {"proxy_id": 1, "product": 50, "userid": 88,
                         "page_size": 0, "page_num": 0}])
    @pytest.mark.asyncio
    async def test_hardware_info_list_management_error(self, data):
        resp_str, status = await post_request(self.url, data)
        assert status == 200
        resp_dict = json.loads(resp_str)
        assert resp_dict["data"]["total"] == 0
