import json
import pytest
from unify_api.tests.constants_t import TOKEN, HTTP_PREFIX
from pot_libs.aiohttp_util.aiohttp_utils import AioHttpUtils


@pytest.mark.parametrize('data', [
    {
        "cid": 73,
        "point_id": -1,
        "date_type": "day",
        "start": "2020-07-30 00:00:00",
        "end": "2020-07-30 23:59:59",
        "product": 3
    },
    {
        "cid": 90,
        "point_id": -1,
        "date_type": "month",
        "start": "2020-06-01 00:00:00",
        "end": "2020-07-30 23:59:59",
        "product": 3
    }
])
@pytest.mark.asyncio
async def test_security_index(data):
    """
    获取首页今日或者近30天安全报警统计信息
    """
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/home-page/security-info"
            f"/security-index",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert all([resp_str["data"]["first_alarm"],
                resp_str["data"]["second_alarm"]])


@pytest.mark.parametrize('data', [
    {
        "cids": [90],
        "date_type": "day",
        "start": "2020-07-30 00:00:00",
        "end": "2020-07-30 23:59:59",
        "product": 3
    },
    {
        "cids": [90],
        "date_type": "month",
        "start": "2020-07-01 00:00:00",
        "end": "2020-07-30 23:59:59",
        "product": 3
    }
])
@pytest.mark.asyncio
async def test_alarm_level_distribution(data):
    """
    获取工厂(可多个)日, 月份安全报警不同等级时间分布信息
    """
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/home-page/security-info"
            f"/alarm-level-distribution",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert all([resp_str["data"]["first_alarm"],
                resp_str["data"]["second_alarm"]])


@pytest.mark.parametrize('data', [
    {
        "cids": [90],
        "date_type": "day",
        "start": "2020-07-30 00:00:00",
        "end": "2020-07-30 23:59:59",
        "product": 3
    },
    {
        "cids": [90],
        "date_type": "month",
        "start": "2020-07-01 00:00:00",
        "end": "2020-07-30 23:59:59",
        "product": 3
    }
])
@pytest.mark.asyncio
async def test_alarm_content_distribution(data):
    """
    获取工厂(可多个)日, 月份安全报警不同等级时间分布信息
    """
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/home-page/security-info"
            f"/alarm-content-distribution",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert all([resp_str["data"]["temperature"],
               resp_str["data"]["residual_current"],
                resp_str["data"]["electric_param"],
                resp_str["data"]["content_detail"]])


@pytest.mark.parametrize('data', [
    {
        "cids": [73, 90],
        "date_type": "day",
        "start": "2020-07-30 00:00:00",
        "end": "2020-07-30 23:59:59",
        "product": 3
    },
    {
        "cids": [73, 90],
        "date_type": "month",
        "start": "2020-07-01 00:00:00",
        "end": "2020-07-30 23:59:59",
        "product": 3
    }
])
@pytest.mark.asyncio
async def test_alarm_summary(data):
    """
    获取工厂(可多个)日, 月份安全报警不同等级时间分布信息
    """
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/home-page/security-info/alarm-summary",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
