import json
import pytest
from unify_api.tests.constants_t import TOKEN, HTTP_PREFIX
from pot_libs.aiohttp_util.aiohttp_utils import AioHttpUtils


@pytest.mark.parametrize('data', [
    {
        "month": "2021-07",
        "cids": [66, 73, 74],
        "product": 0
    },
])
@pytest.mark.asyncio
async def test_elec_count_info(data):
    """安电u管理版本-用电安全-上方统计数据接口"""
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/electric/proxy-safe"
            f"/elec-count-info",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert all([resp_str["data"]["total_cid_cnt"],
                resp_str["data"]["total_run_days"],
                resp_str["data"]["security_level"],
                resp_str["data"]["alarm_content"]])


@pytest.mark.parametrize('data', [
    {
        "month": "2020-10",
        "cids": [66, 73, 74],
        "product": -1,
        "page_size": 10,
        "page_num": 1,
        "sort_field": "electric_index",
        "sort_direction": "desc, asc"
    },
])
@pytest.mark.asyncio
async def test_elec_list(data):
    """安电u管理版本获取用电安全月度数据"""
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/electric/proxy-safe"
            f"/elec-list",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert resp_str["data"]["total"] == len(resp_str["data"]["rows"])