from dataclasses import dataclass

from pot_libs.common.components.fields import Cid
from pot_libs.sanic_api import Model
from pot_libs.sanic_api.column import Int, List, Str, Dict, Float


@dataclass
class DdReq(Model):
    cid: Cid
    storeys: list = List("storey_id").eg([100, 101])


@dataclass
class DdResp(Model):
    res_data: list = List("降尘措施").eg(
        [
            {"name": "喷淋", "data": [{"key1": 10}, {"key2": 11}]},
            {"name": "雾炮", "data": [{"key1": 10}, {"key2": 11}]}
        ]
    )


@dataclass
class DtReq(Model):
    cid: Cid
    tsp_id: int = Int("tsp监测点id").eg(1)


@dataclass
class DdwReq(Model):
    cid: Cid
    point_id: int = Int("point_id").eg(428)
    start: str = Str("开始时间").eg("2021-04-22 00:00:00")
    end: str = Str("结束时间").eg("2021-04-22 23:59:59")


@dataclass
class DdwResp(Model):
    slots: list = List("slots").eg(["00:00", "00:15", "00:30"])
    value: list = List("时间段对应的值").eg([0.1, 0.2, 0.3])


@dataclass
class DtResp(Model):
    pm2_5: float = Float("pm2.5").eg(23.1)
    pm10: float = Float("pm10").eg(27.2)
    tsp: float = Float("tsp").eg(120.1)


@dataclass
class ThReq(Model):
    cid: Cid
    tsp_id: int = Int("point_id").eg(1)
    start: str = Str("开始时间").eg("2021-11-01 00:00:00")
    end: str = Str("结束时间").eg("2021-11-30 23:59:59")


@dataclass
class ThResp(Model):
    pm2_5: dict = Dict("pm2.5").eg({"threshold": 75, "value_slots": [23, 24]})
    pm10: dict = Dict("pm10").eg({"threshold": 150, "value_slots": [80, 81]})
    tsp: dict = Dict("tsp").eg({"threshold": 300, "value_slots": [101, 102]})
    time_slots: list = List('时间轴').items(Str('时间'))
    pm2_5_predict: dict = Dict("pm25预测数据").eg({"value_slots": [101, 102]})
    pm10_predict: dict = Dict("pm10预测数据").eg({"value_slots": [101, 102]})
    tsp_predict: dict = Dict("tsp预测数据").eg({"value_slots": [101, 102]})
    pm2_5_contrast: dict = Dict("pm25对比数据").eg({"value_slots": [101, 102]})
    pm10_contrast: dict = Dict("pm10对比数据").eg({"value_slots": [101, 102]})


@dataclass
class TisReq(Model):
    cid: Cid
    tsp_id: int = Int("point_id").eg(1)
    start: str = Str("开始时间").eg("2021-04-26 00:00:00")
    end: str = Str("结束时间").eg("2021-04-26 23:59:59")


@dataclass
class TisResp(Model):
    pm2_5: dict = Dict("pm2.5").eg(
        {"max": 63, "max_time": "2021-04-26 14:33:12",
         "min": 26, "min_time": "2021-04-26 14:43:12",
         "avg": 45}
    )
    pm10: dict = Dict("pm10").eg(
        {"max": 63, "max_time": "2021-04-26 14:33:12",
         "min": 26, "min_time": "2021-04-26 14:43:12",
         "avg": 45}
    )
    tsp: dict = Dict("tsp").eg(
        {"max": 63, "max_time": "2021-04-26 14:33:12",
         "min": 26, "min_time": "2021-04-26 14:43:12",
         "avg": 45}
    )


@dataclass
class DeReq(Model):
    cid: Cid


@dataclass
class DeResp(Model):
    pm2_5: dict = Dict("pm2.5").eg({"data": 35, "grade": "优"})
    pm10: dict = Dict("pm10").eg({"data": 42, "grade": "优"})
    tsp: dict = Dict("tsp").eg({"data": 120, "grade": "优"})


@dataclass
class IrmResp(Model):
    water: dict = Dict("喷淋").eg({"start": 2, "stop": 8})
    fog_gun: dict = Dict("雾炮").eg({"start": 1, "stop": 7})


@dataclass
class IosResp(Model):
    water: list = List("喷淋").eg({"name": "喷淋1#", "run_time": "运行时间",
                                 "use_water": "用水量"})
    fog_gun: list = List("雾炮").eg({"name": "7#雾炮机", "run_time": "运行时间",
                                   "use_kwh": "用电量"})


@dataclass
class ItiResp(Model):
    pm2_5: dict = Dict("pm2.5").eg({"data": 35, "grade": "优"})
    pm10: dict = Dict("pm10").eg({"data": 42, "grade": "优"})
    tsp: dict = Dict("tsp").eg({"data": 120, "grade": "优"})
    today_water: float = Float("今日降尘用水").eg(25.21)
    today_kwh: float = Float("今日降尘用电").eg(43.12)


@dataclass
class SaResp(Model):
    pm2_5: list = List("pm2.5").eg([23, 24])
    pm10: list = List("pm10").eg([80, 81])
    tsp: list = List("tsp").eg([101, 102])
    water: list = List("喷淋").eg([101, 102])
    fog_gun: list = List("雾炮").eg([101, 102])
    time_slots: list = List('时间轴').items(Str('时间'))
    r_water_pm25: dict = Dict("喷淋措施与PM2.5相关性分析").eg(
        {"r": -0.39, "name": "低度相关"})
    r_water_pm10: dict = Dict("喷淋措施与PM10相关性分析").eg(
        {"r": -0.51, "name": "显著相关"})
    r_water_tsp: dict = Dict("喷淋措施与tsp相关性分析").eg(
        {"r": -0.53, "name": "显著相关"})
    r_gun_pm25: dict = Dict("雾炮措施与PM2.5相关性分析").eg(
        {"r": -0.39, "name": "低度相关"})
    r_gun_pm10: dict = Dict("雾炮措施与PM10相关性分析").eg(
        {"r": -0.51, "name": "显著相关"})
    r_gun_tsp: dict = Dict("雾炮措施与tsp相关性分析").eg(
        {"r": -0.53, "name": "显著相关"})


@dataclass
class WsStatiReq(Model):
    cid: Cid
    date_type: str = Str("时间类型->day/month").eg("day")
    start: str = Str("开始时间").eg("2020-07-30 00:00:00")
    end: str = Str("结束时间").eg("2020-07-30 23:59:59")


@dataclass
class WsStatiResp(Model):
    pm2_5: list = List("pm2.5").eg([23, 24])
    pm10: list = List("pm10").eg([80, 81])
    tsp: list = List("tsp").eg([101, 102])
    water_or_electric: list = List("用水量或者用电量").eg([101, 102])
    slots: list = List("slots").eg(["00:00", "00:15", "00:30"])


@dataclass
class TpdResp(Model):
    pm2_5: dict = Dict("pm2.5").eg(
        {"max": 63, "max_time": "2021-04-26 14:33:12",
         "min": 26, "min_time": "2021-04-26 14:43:12",
         "avg": 45}
    )
    pm10: dict = Dict("pm10").eg(
        {"max": 63, "max_time": "2021-04-26 14:33:12",
         "min": 26, "min_time": "2021-04-26 14:43:12",
         "avg": 45}
    )
    tsp: dict = Dict("tsp").eg(
        {"max": 63, "max_time": "2021-04-26 14:33:12",
         "min": 26, "min_time": "2021-04-26 14:43:12",
         "avg": 45}
    )


@dataclass
class TcdResp(Model):
    pm2_5: dict = Dict("pm2.5").eg(
        {"max": 63, "max_time": "2021-04-26 14:33:12",
         "min": 26, "min_time": "2021-04-26 14:43:12",
         "avg": 45}
    )
    pm10: dict = Dict("pm10").eg(
        {"max": 63, "max_time": "2021-04-26 14:33:12",
         "min": 26, "min_time": "2021-04-26 14:43:12",
         "avg": 45}
    )


@dataclass
class AdReq(Model):
    cid: int = Int('工厂id').eg(117)
    start: str = Str("开始时间").eg("2021-11-01 00:00:00")
    end: str = Str("结束时间").eg("2021-11-30 23:59:59")
    measure_type: str = Str("喷淋 water 或者雾炮 fogcan").eg("water")
    page_num: int = Int("page_num").eg(1)
    page_size: int = Int("page_size").eg(5)


@dataclass
class AdResp(Model):
    all_count: int = Int("启动次数").eg(5)
    effective_count: int = Int("有效次数").eg(2)
    effective_rate: str = Str("有效率").eg("40%")
    page_data: list = List("描述数据").eg([
        {"datetime": "2021-10-20 08:00-09:00", "effective": "喷淋用水8.42m³",
         "is_effective": 1, "message": "PM2.5、PM10、TSP出现明显下降"}])
