# -*- coding:utf-8 -*-
"""
DATE：2024/3/5 16:19

"""
from pot_libs.sanic_api import summary
from pot_libs.logger import log
from unify_api.modules.common.components.common_cps import SuccessRsp
from unify_api.modules.qkadmin.components.news_info_cps import (
    NewsPagesReq, NewsPagesRsp, NewsInfo, ReviseNewsReq, ReviseNewsSeoReq
)
from unify_api.modules.qkadmin.service.news_mgr_srv import (
    upload_news_qs, save_news_info, load_news_pages, update_news_info,
    update_news_seo, delete_news, top_news
)


@summary("发布文章")
async def post_publish_news(request, *args, **kwargs) -> SuccessRsp:
    log.info(f"post_publish_news:{request.form}")
    log.info(f"post_publish_news:{len(request.files.getlist('file1'))}")
    log.info(f"post_publish_news:{len(request.files.getlist('file2'))}")
    is_success, news_url, cover_url = await upload_news_qs(request)
    if is_success:
        form = request.form
        d_news_info = dict(title=form.get("title"), author=form.get("author"),
                           pub_time=form.get("pub_time"),
                           news_type=int(form.get("news_type")))
        await save_news_info(d_news_info, news_url, cover_url)
        return SuccessRsp(success=1, message="发布文章成功")

    return SuccessRsp(success=0, message="发布文章失败")


@summary("重新编辑文章（标题/内容/封面）")
async def post_revise_news(request, body: ReviseNewsReq) -> SuccessRsp:
    news_id, title = body.news_id, body.title
    is_success, url_article, url_cover = await upload_news_qs(request)
    if is_success:
        await update_news_info(news_id, title, url_article, url_cover)
        return SuccessRsp(success=1, message="修改文章成功")

    return SuccessRsp(success=0, message="修改文章失败")


@summary("修改文章SEO优化")
async def post_revise_news_seo(request, body: ReviseNewsSeoReq) -> SuccessRsp:
    news_id, keywords, contents = body.news_id, body.keywords, body.contents
    await update_news_seo(news_id, keywords, contents)
    return SuccessRsp(success=1, message="修改文章SEO优化成功")


@summary("删除文章")
async def post_delete_news(request, body: ReviseNewsReq) -> SuccessRsp:
    news_id = body.news_id
    is_success = await delete_news(news_id)
    if is_success:
        return SuccessRsp(success=1, message="删除文章成功")

    return SuccessRsp(success=0, message="删除文章失败")


@summary("置顶/取消置顶文章")
async def post_top_news(request, body: ReviseNewsReq) -> SuccessRsp:
    news_id, top = body.news_id, body.top
    is_success = await top_news(news_id, top)
    if is_success:
        return SuccessRsp(success=1, message="修改文章置顶成功")

    return SuccessRsp(success=0, message="修改文章置顶失败")


@summary("后台文章列表")
async def post_news_pages(request, body: NewsPagesReq) -> NewsPagesRsp:
    page_num = int(body.page_num)
    page_size = int(body.page_size)
    news_type = int(body.news_type) if body.news_type else 0
    s_dts = body.start_time
    e_dts = body.end_time
    se_title = body.se_title
    params = dict(page_num=page_num, page_size=page_size, news_type=news_type,
                  s_dts=s_dts, e_dts=e_dts, se_title=se_title)
    total, articles = await load_news_pages(params)
    rsp_articles = [
        NewsInfo(id=r["id"], title=r["title"], author=r["author"],
                 pub_time=str(r["pub_time"]), news_type=r["news_type"],
                 top=r["top"]) for r in articles]
    return NewsPagesRsp(total=total, articles=rsp_articles)
