# -*- coding:utf-8 -*-
"""
DATE：2024/3/7 10:55

"""
from pot_libs.sanic_api import summary
from unify_api.modules.qkadmin.components.contact_us_cps import (
    ContactsReq, ContactsRsp, ContactInfo
)
from unify_api.modules.qkadmin.service.contact_us_srv import (
    load_contact_records
)


@summary("联系我们记录")
async def post_contact_records(request, body: ContactsReq) -> ContactsRsp:
    page_num = int(body.page_num)
    page_size = int(body.page_size)
    total, records = await load_contact_records(page_num, page_size)
    contacts = [ContactInfo(id=r["id"], user_name=r["user_name"],
                            tele=r["tele"], company=r["company"],
                            msg=r["msg"], create_time=str(r["create_time"]),
                            email=r["email"]) for r in records]
    return ContactsRsp(total=total, contacts=contacts)
