# -*- coding:utf-8 -*-
"""
DATE：2024/3/5 16:27

"""
import pendulum
from uuid import uuid4
from unify_api.constants import OSS_NEWS
from pot_libs.logger import log
from unify_api.modules.common.procedures.file_operate_pds import upload_file
from pot_libs.mysql_util.mysql_util import MysqlUtil


async def upload_file_helper(file):
    is_upload, file_url = False, ""
    file_name = file.name
    file_name_lst = file_name.rsplit(".", 1)
    if len(file_name_lst) <= 1:
        return False, file_url

    if file.body:
        now_dt = pendulum.now()
        yr, month = now_dt.year, now_dt.month
        file_url = f"{OSS_NEWS}/{yr}/{month}/{uuid4()}.{file_name_lst[1]}"

        log.info(f"准备上传文件 {file_name} {file_url}")
        is_upload = await upload_file(file, file_url)

    return is_upload, file_url


async def upload_news_qs(request):
    """附件上传"""
    url_article, url_cover = "", ""
    news_file = request.files.getlist("file1")[0]
    cover_file = request.files.getlist("file2")[0]
    if news_file.name == cover_file.name:
        return False, url_article, url_cover

    news_upload, url_article = await upload_file_helper(news_file)
    if news_upload and url_article:
        log.info(f"上传文章成功, url {url_article}")

    cover_upload, url_cover = await upload_file_helper(cover_file)
    if cover_upload and url_cover:
        log.info(f"上传文章封面, url {url_cover}")

    if all([news_file, url_article, cover_upload, url_cover]):
        log.info(f"上传文章和封面成功 {url_article} {url_cover}")
        return True, url_article, url_cover

    return False, url_article, url_cover


async def save_news_info(news_info, news_url, cover_url):
    sql = "INSERT INTO official_web.news_info (title, news_type, news_url, " \
          "cover_url, keywords, contents, pub_time) " \
          "VALUES (%s, %s, %s, %s, %s, %s, %s);"
    async with MysqlUtil(db="official_web") as conn:
        await conn.execute(sql, (news_info["title"], news_info["news_type"],
                                 news_url, cover_url, news_info["keywords"],
                                 news_info["contents"],
                                 str(news_info["pub_time"]),))


async def update_news_info(news_id, title, news_url, cover_url):
    async with MysqlUtil(db="official_web") as conn:
        if cover_url:
            sql = "UPDATE official_web.news_info " \
                  "SET title=%s, news_url=%s, cover_url=%s WHERE id=%s;"
            return await conn.execute(sql, (news_id, title, news_url,
                                            cover_url))

        sql = "UPDATE official_web.news_info " \
              "SET title=%s, news_url=%s WHERE id=%s;"
        return await conn.execute(sql, (news_id, title, news_url,))


async def update_news_seo(news_id, keywords, contents):
    async with MysqlUtil(db="official_web") as conn:
        sql = "UPDATE official_web.news_info " \
              "SET keywords=%s, contents=%s WHERE id=%s;"
        return await conn.execute(sql, (news_id, keywords, contents,))


async def delete_news(news_id):
    async with MysqlUtil(db="official_web") as conn:
        sql = "DELETE FROM official_web.news_info WHERE id=%s;"
        await conn.execute(sql, (news_id,))
        sql = "SELECT 1 FROM official_web.news_info WHERE id=%s LIMIT 1;"
        rlt = await conn.execute(sql, (news_id,))
        return False if rlt else True


async def top_news(news_id, top):
    async with MysqlUtil(db="official_web") as conn:
        sql = "UPDATE official_web.news_info SET top=%s WHERE id=%s;"
        await conn.execute(sql, (top, news_id,))
        sql = "SELECT 1 FROM official_web.news_info WHERE id=%s AND top=%s;"
        return await conn.execute(sql, (news_id, top,))


async def load_news_pages(params):
    page_num, page_size = params["page_num"], params["page_size"]
    news_type, se_title = params["news_type"], params["se_title"]
    s_dts, e_dts = params["s_dts"], params["e_dts"]
    offsets = 0 if page_num == 0 else (page_num - 1) * page_size
    conds, param_lst = [], []
    if news_type:
        param_lst.append(news_type)
        conds.append(f"news_type=%s")
    if s_dts:
        s_dt = pendulum.parse(s_dts, tz="Asia/Shanghai")
        param_lst.append(str(s_dt))
        conds.append(f"pub_time>=%s")
    if e_dts:
        e_dt = pendulum.parse(e_dts, tz="Asia/Shanghai")
        param_lst.append(str(e_dt))
        conds.append(f"pub_time<%s")
    if se_title:
        param_lst.append(se_title)
        conds.append(f"title LIKE %{se_title}%")

    if len(conds) > 1:
        conds_str = "WHERE " + " AND ".join(conds)
    elif len(conds) == 1:
        conds_str = f"WHERE {conds[0]} "
    else:
        conds_str = ""

    param_lst += [page_size, offsets]
    async with MysqlUtil(db="official_web") as conn:
        if news_type:
            sql = "SELECT count(*) FROM official_web.news_info " \
                  "WHERE news_type=%s;"
            total = await conn.fetch_value(sql, (news_type,))
        else:
            sql = "SELECT count(*) FROM official_web.news_info;"
            total = await conn.fetch_value(sql)

        sql = f"SELECT id, title, author, news_type, pub_time, top " \
              f"FROM official_web.news_info " \
              f"{conds_str} " \
              f"ORDER BY pub_time DESC, id LIMIT %s OFFSET %s;"

        articles = await conn.fetchall(sql, (tuple(param_lst)))
        return total, articles
