# -*- coding:utf-8 -*-
"""
DATE：2024/3/7 11:08

"""
from pot_libs.mysql_util.mysql_util import MysqlUtil


async def load_contact_records(page_num, page_size):
    offsets = 0 if page_num == 0 else (page_num - 1) * page_size
    async with MysqlUtil(db="official_web") as conn:
        sql = "SELECT count(*) FROM official_web.contact_record;"
        total = await conn.fetch_value(sql)

        sql = f"SELECT * FROM official_web.contact_record " \
              f"ORDER BY create_time DESC, id LIMIT %s OFFSET %s;"

        records = await conn.fetchall(sql, (page_size, offsets))
        return total, records
