# -*- coding:utf-8 -*-
"""
DATE：2024/3/5 13:56

"""
from dataclasses import dataclass
from pot_libs.sanic_api import Model
from pot_libs.sanic_api.column import Opt, Int, List, Str


@dataclass
class NewsInfoReq(Model):
    news_id: str = Str("文章id").eg("12")


@dataclass
class NewsInfoRsp(Model):
    title: str = Str("文章标题").eg("喜报丨热烈庆祝清科优能被评定为深圳市“专精特新”企业！")
    contents: str = Str("文章内容").eg("喜报丨热烈庆祝清科优能被评定为深圳市“专精特新”企业！")
    pub_time: str = Str("发布时间").eg("2023-12-29 18:06")


@dataclass
class PubNewsReq(Model):
    title: str = Opt(Str("文章标题").eg("喜报丨热烈庆祝清科优能被评定为深圳市“专精特新”企业！"))
    author: str = Opt(Str("文章作者").eg("清科优能"))
    news_type: int = Opt(Int("文章类型（1：公司新闻， 2：行业新闻）").eg(1))
    pub_time: str = Opt(Str("发布时间").eg("2023-12-29 18:06"))
    keywords: str = Opt(Str("文章关键词").eg("清科优能"))
    contents: str = Opt(Str("文章描述").eg("清科优能"))


@dataclass
class ReviseNewsReq(Model):
    news_id: str = Str("文章id").eg("12")
    title: str = Opt(Str("文章标题").eg("喜报丨热烈庆祝清科优能被评定为深圳市“专精特新”企业！"))
    top: int = Opt(Int("置顶/取消置顶").eg(0))


@dataclass
class ReviseNewsSeoReq(Model):
    news_id: str = Str("文章id").eg("12")
    keywords: str = Opt(Str("文章关键词").eg("清科优能"))
    contents: str = Opt(Str("文章描述").eg("清科优能"))


@dataclass
class NewsPagesReq(Model):
    news_type: int = Opt(Int("文章类型（1：公司新闻， 2：行业新闻） 不传则返回所有类型文章").eg(1))
    page_num: int = Int("页码").eg(1)
    page_size: int = Opt(Int("条数").eg(10))
    start_time: str = Opt(Str("起始时间").eg("2024-03-07 00:00:00"))
    end_time: str = Opt(Str("截止时间").eg("2023-12-29 18:06"))
    se_title: str = Opt(Str("搜索的文章标题").eg("万物梁行携手清科优能"))


@dataclass
class NewsInfo(Model):
    id: int = Opt(Int("文章ID").eg(1))
    title: str = Str("文章标题").eg("喜报丨热烈庆祝清科优能被评定为深圳市“专精特新”企业！")
    author: str = Str("文章作者").eg("清科优能")
    pub_time: str = Str("发布时间").eg("2023-12-29 18:06")
    news_type: int = Int("文章类型（1：公司新闻， 2：行业新闻）").eg(1)
    top: int = Opt(Int("是否置顶").eg(0))
    contents: str = Opt(Str("文章内容").eg("喜报丨热烈庆祝清科优能被评定为深圳市“专精特新”企业！"))
    cover_url: str = Opt(Str("文章封面URL").eg("xxxxxxxxxx"))


@dataclass
class NewsPagesRsp(Model):
    total: int = Int("文章总数").eg(99)
    articles: list = List("文章列表").items(NewsInfo)
