# -*- coding:utf-8 -*-
"""
DATE：2024/3/6 13:47

"""
from pot_libs.logger import log
from pot_libs.qingstor_util.qs_client import QsClient


async def upload_file(file, qs_url):
    file_body = file.body
    if file_body:
        async with QsClient() as client:
            resp = await client.put_file(key=qs_url, data=file_body)
            log.info(f"upload to qingstor the resp: {resp} {qs_url}")
            return 1
    else:
        return None
