from unify_api.modules.zhiwei_u.components.install_sheet_cps import SlResp
from unify_api.modules.zhiwei_u.dao.install_sheet_dao import \
    install_sheet_by_cid


async def sheet_list_service(cid):
    """安装单管理-文件列表"""
    install_list = await install_sheet_by_cid(cid)
    if not install_list:
        return SlResp(customer=[], hardware=[])
    customer_list = []
    hardware_list = []
    for install in install_list:
        belong = install["belong"]
        tmp_dic = {
            "sheet_id": install["id"],
            "doc_name": install["doc_name"],
        }
        if belong == 0:
            customer_list.append(tmp_dic)
        else:
            hardware_list.append(tmp_dic)
    return SlResp(customer=customer_list, hardware=hardware_list)
