from pot_libs.sanic_api import summary
from unify_api.modules.tsp_water.components.drop_dust_cps import DtReq, \
    DtResp, ThReq, ThResp, TisReq, TisResp, DeReq, DeResp, SaResp, TcdResp, \
    TpdResp, AdReq, AdResp
from unify_api.modules.tsp_water.service.tsp_service import \
    real_time_service, tsp_history_service, tsp_index_statistics_service, \
    day_env_service, stat_analysis_service, tsp_predict_deviation_service, \
    tsp_contrast_deviation_service, analysis_describe_service, \
    day_env_service_new15, tsp_index_statistics_service_new15


@summary("TSP信息-实时参数")
async def post_real_time(req, body: DtReq) -> DtResp:
    tsp_id = body.tsp_id
    # return await real_time_service(tsp_id)
    return DtResp(pm2_5=None, pm10=None, tsp=None)


@summary("TSP信息-历史曲线")
async def post_tsp_history(req, body: ThReq) -> ThResp:
    tsp_id = body.tsp_id
    start = body.start
    end = body.end
    # return await tsp_history_service(tsp_id, start, end)
    return ThResp(
        pm2_5={
            "threshold": 75,
            "value_slots": []
        },
        pm10={
            "threshold": 150,
            "value_slots": []
        },
        tsp={
            "threshold": 300,
            "value_slots": []
        },
        time_slots=[
            "string"
        ],
        pm2_5_predict={
            "value_slots": []
        },
        pm10_predict={
            "value_slots": []
        },
        tsp_predict={
            "value_slots": []
        },
        pm2_5_contrast={
            "value_slots": []
        },
        pm10_contrast={
            "value_slots": []
        }
    )


@summary("TSP信息-指标统计")
async def post_tsp_index_statistics(req, body: TisReq) -> TisResp:
    tsp_id = body.tsp_id
    start = body.start
    end = body.end
    # return await tsp_index_statistics_service(tsp_id, start, end)
    # return await tsp_index_statistics_service_new15(tsp_id, start, end)
    return TisResp(pm2_5={}, pm10={}, tsp={})


@summary("当日环境")
async def post_day_env(req, body: DeReq) -> DeResp:
    cid = body.cid
    return await day_env_service_new15(cid)


@summary("统计分析-扬尘")
async def post_stat_analysis(req, body: ThReq) -> SaResp:
    cid = body.cid
    tsp_id = body.tsp_id
    start = body.start
    end = body.end
    # return await stat_analysis_service(cid, tsp_id, start, end)
    return SaResp(pm2_5=[], pm10=[], tsp=[], water=[], fog_gun=[],
                  time_slots=[], r_water_pm25={}, r_water_pm10={},
                  r_water_tsp={}, r_gun_pm25={}, r_gun_pm10={}, r_gun_tsp={})


@summary("TSP信息-预测偏差")
async def post_tsp_predict_deviation(req, body: TisReq) -> TpdResp:
    tsp_id = body.tsp_id
    start = body.start
    end = body.end
    # return await tsp_predict_deviation_service(tsp_id, start, end)
    return TpdResp(pm2_5={}, pm10={}, tsp={})


@summary("TSP信息-对比偏差")
async def post_tsp_contrast_deviation(req, body: TisReq) -> TcdResp:
    tsp_id = body.tsp_id
    start = body.start
    end = body.end
    # return await tsp_contrast_deviation_service(tsp_id, start, end)
    return TcdResp(pm2_5={}, pm10={})


@summary("统计分析-扬尘-描述")
async def post_analysis_describe(req, body: AdReq) -> AdResp:
    cid = body.cid
    start = body.start
    end = body.end
    page_num = body.page_num
    page_size = body.page_size
    measure_type = body.measure_type
    return await analysis_describe_service(cid, start, end, page_num,
                                           page_size, measure_type)
