from pot_libs.sanic_api import summary
from unify_api.modules.product_info.components.hardware_cps import (
    HardwareInfoRespList, HardwareInfoReq, HardwareInfoCountResp,
    HardwareInfoCountReq, HisReq, HisResp, HlsReq, HlsResp, HardwareInfoManReq,
    HardwareInfoManResq, HardwareInfoListReq, HardwareInfoListResq
)
from unify_api.modules.product_info.procedures.hardware_pds import (
    company_available, get_user_hardware_info, hardware_statistics,
    get_user_hardware_info_new15, hardware_statistics_new15
)
from pot_libs.logger import log
from unify_api.modules.product_info.service.hardware_info import \
    hardware_info_sdu_service, hardware_list_sdu_service, \
    hardware_info_management_service, hardware_info_list_manage_service
from unify_api.modules.common.procedures.cids import get_cids, get_proxy_cids


@summary("获取硬件信息")
async def post_hardware_info_list(request, body: HardwareInfoReq) -> HardwareInfoRespList:
    company_id = body.cid
    page_size, page_num = body.page_size, body.page_num
    log.info(
        f"post_hardware_info company_id={company_id}, page_size={page_size}, page_num={page_num}"
    )
    comp_available = await company_available(company_id)
    if not comp_available:
        return HardwareInfoRespList.user_error()

    # page_map = await get_user_hardware_info(company_id, page_num, page_size)
    page_map = await get_user_hardware_info_new15(company_id, page_num, page_size)
    return HardwareInfoRespList(rows=page_map["rows"], total=page_map["total"])


@summary("硬件统计信息")
async def post_hardware_info_count(request, body: HardwareInfoCountReq) -> HardwareInfoCountResp:
    company_id = body.cid
    # statistics_info_map = await hardware_statistics(company_id)
    statistics_info_map = await hardware_statistics_new15(company_id)
    return HardwareInfoCountResp(
        installed_number=statistics_info_map["installed_number"],
        legal_measurement_number=statistics_info_map["legal_measurement_number"],
        start_time=statistics_info_map["start_time"],
        power_capacity=statistics_info_map["power_capacity"],
    )


@summary("安装信息-识电u")
async def post_hardware_info_sdu(req, body: HisReq) -> HisResp:
    cid = body.cid
    return await hardware_info_sdu_service(cid)


@summary("安装信息分页数据-识电u")
async def post_hardware_list_sdu(req, body: HlsReq) -> HlsResp:
    cid = body.cid
    page_size, page_num = body.page_size, body.page_num
    return await hardware_list_sdu_service(cid, page_num, page_size)


@summary("管理版-关于我们-统计")
async def post_hardware_info_management(req, body: HardwareInfoManReq) -> HardwareInfoManResq:
    product = body.product
    # user_id = 88 if req.ctx else req.ctx.user_id
    try:
        user_id = req.ctx.user_id
    except:
        user_id = req.json.get("userid")   # 给跑测试用的
    # cids = await get_cids(user_id, product)
    proxy_id = body.proxy_id
    cids = await get_proxy_cids(user_id, product, proxy_id)
    if not cids:
        return HardwareInfoManResq(
            project_count=0, start_time="", detection_point_count=0
    )
    return await hardware_info_management_service(cids)


@summary("管理版-关于我们-分页")
async def post_hardware_info_list_management(req, body: HardwareInfoListReq) \
        -> HardwareInfoListResq:
    product = body.product
    page_size = body.page_size
    page_num = body.page_num
    # user_id = 88 if req.ctx else req.ctx.user_id
    try:
        user_id = req.ctx.user_id
    except:
        user_id = req.json.get("userid")  # 给跑测试用的
    proxy_id = body.proxy_id
    cids = await get_proxy_cids(user_id, product, proxy_id)
    if not cids:
        return HardwareInfoListResq(rows=[], total=0)
    return await hardware_info_list_manage_service(cids, page_num, page_size)
