from dataclasses import dataclass
from pot_libs.sanic_api import Model
from pot_libs.sanic_api.column import Opt, Int, List, Str


@dataclass
class ProductResp(Model):
    prod_id: list = List("cid").eg([
        {"id": 0, "name": "全部"},
        {"id": 1, "shortname": "知电U"},
    ])


@dataclass
class SelectUserReq(Model):
    prod_id: int = Int("产品类型 3-安电u管理 4-识电U")


@dataclass
class SelecPointReq(Model):
    cid: int = Int("客户id")


@dataclass
class SelectUserResp(Model):
    data:  list = List("cid").eg([
        {"cid": 32, "shortname": "大地水泥"},
        {"cid": 34, "shortname": "广东演示工厂1"},
    ])


@dataclass
class Success(Model):
    success: int = Int('请求成功').eg(1)
    message: str = Str("具体错误信息").eg("操作成功")
    order_num: str = Opt(Str("订单号").eg("S21071918083882"))


@dataclass
class FileSuccess(Model):
    success: int = Int('请求成功').eg(1)
    message: str = Str("具体错误信息").eg("操作成功")
    id: str = Str("流程id").eg(1)


@dataclass
class SuccessResp(Model):
    success: int = Int('请求成功').eg(1)
    message: str = Str("具体错误信息").eg("操作成功")
    fid: list = Opt(List("文件列表id").eg([23, 24]))


@dataclass
class WarningStateIgnoreReq(Model):
    id: list = List('工单id').eg([1, 2, 3])
    remark: str = Str("备注").eg("去处理吧")


@dataclass
class WarningStateFocusReq(Model):
    id: list = List('工单id').eg([1, 2, 3])
