from dataclasses import dataclass

from pot_libs.sanic_api import Model
from pot_libs.sanic_api.column import List, Float, Str, Int, Opt


@dataclass
class ProxyRankingReq(Model):
    month: str = Str("月份").eg("2020-10")
    cids: list = List("公司id列表").items(Int("公司id")).eg([66, 73, 74])
    product: int = Int("产品 1-知电U 2-安电U 3-安电u管理版本 4-识电u")


@dataclass
class ProxyRankingResp(Model):
    safety: list = List("安全指数")
    health: list = List("健康指数")
    kwh: list = List("电量")
    charge: list = List("电费")
