# -*- coding:utf-8 -*-
#
# Author:jing
# Date: 2020/7/9
from dataclasses import dataclass

from pot_libs.sanic_api import Model
from pot_libs.sanic_api.column import List, Float, Opt, Str, Int, Dict
from pot_libs.common.components.fields import DateTime, Cid


@dataclass
class Power(Model):
    p: list = List('有功').items(Float())
    q: list = List('无功').items(Float())


@dataclass
class U(Model):
    """电压"""
    ua: list = Opt(List('ua').items(Float()))
    ub: list = Opt(List('ub').items(Float()))
    uc: list = Opt(List('uc').items(Float()))
    uab: list = Opt(List('uab').items(Float()))
    ucb: list = Opt(List('ucb').items(Float()))


@dataclass
class VoltageDev(Model):
    """电压偏差"""
    ua_dev: list = Opt(List('ua_dev').items(Float()))
    ub_dev: list = Opt(List('ub_dev').items(Float()))
    uc_dev: list = Opt(List('uc_dev').items(Float()))
    uab_dev: list = Opt(List('uab_dev').items(Float()))
    ucb_dev: list = Opt(List('ucb_dev').items(Float()))


@dataclass
class I(Model):
    """电流"""
    ia: list = List('ia').items(Float())
    ib: list = Opt(List('ib').items(Float()))
    ic: list = List('ic').items(Float())


@dataclass
class ThreePhaseImbalance(Model):
    """三相不平衡度"""
    voltage: list = Opt(List('电压三相不平衡度').items(Float()))
    current: list = Opt(List('电流三相不平衡度').items(Float()))


@dataclass
class VoltageHarmonicRate(Model):
    """电压谐波畸变率"""
    thdua: float = Opt(Float("ua总谐波畸变率"))
    thdub: float = Opt(Float("ub总谐波畸变率"))
    thduc: float = Opt(Float("uc总谐波畸变率"))

    thduab: float = Opt(Float("uab总谐波畸变率"))
    thducb: float = Opt(Float("uab总谐波畸变率"))

    hr3ua: float = Opt(Float("hr3ua谐波畸变率"))
    hr3ub: float = Opt(Float("hr3ub谐波畸变率"))
    hr3uc: float = Opt(Float("hr3uc谐波畸变率"))
    hr3uab: float = Opt(Float("hr3uab谐波畸变率"))
    hr3ucb: float = Opt(Float("hr3ucb谐波畸变率"))

    hr5ua: float = Opt(Float("hr5ua谐波畸变率"))
    hr5ub: float = Opt(Float("hr5ub谐波畸变率"))
    hr5uc: float = Opt(Float("hr5uc谐波畸变率"))
    hr5uab: float = Opt(Float("hr5uab谐波畸变率"))
    hr5ucb: float = Opt(Float("hr5ucb谐波畸变率"))

    hr7ua: float = Opt(Float("hr7ua谐波畸变率"))
    hr7ub: float = Opt(Float("hr7ub谐波畸变率"))
    hr7uc: float = Opt(Float("hr7uc谐波畸变率"))
    hr7uab: float = Opt(Float("hr7uab谐波畸变率"))
    hr7ucb: float = Opt(Float("hr7ucb谐波畸变率"))

    hr9ua: float = Opt(Float("hr9ua谐波畸变率"))
    hr9ub: float = Opt(Float("hr9ub谐波畸变率"))
    hr9uc: float = Opt(Float("hr9uc谐波畸变率"))
    hr9uab: float = Opt(Float("hr9uab谐波畸变率"))
    hr9ucb: float = Opt(Float("hr9ucb谐波畸变率"))

    hr11ua: float = Opt(Float("hr11ua谐波畸变率"))
    hr11ub: float = Opt(Float("hr11ub谐波畸变率"))
    hr11uc: float = Opt(Float("hr11uc谐波畸变率"))
    hr11uab: float = Opt(Float("hr11uab谐波畸变率"))
    hr11ucb: float = Opt(Float("hr11ucb谐波畸变率"))

    hr13ua: float = Opt(Float("hr13ua谐波畸变率"))
    hr13ub: float = Opt(Float("hr13ub谐波畸变率"))
    hr13uc: float = Opt(Float("hr13uc谐波畸变率"))
    hr13uab: float = Opt(Float("hr13uab谐波畸变率"))
    hr13ucb: float = Opt(Float("hr13ucb谐波畸变率"))


@dataclass
class CurrentHarmonicRate(Model):
    """电流谐波畸变率"""
    thdia: float = Opt(Float("ia总谐波畸变率"))
    thdib: float = Opt(Float("ib总谐波畸变率"))
    thdic: float = Opt(Float("ic总谐波畸变率"))

    hr3ia: float = Opt(Float("hr3ia谐波畸变率"))
    hr3ib: float = Opt(Float("hr3ib谐波畸变率"))
    hr3ic: float = Opt(Float("hr3ic谐波畸变率"))

    hr5ia: float = Opt(Float("hr5ia谐波畸变率"))
    hr5ib: float = Opt(Float("hr5ib谐波畸变率"))
    hr5ic: float = Opt(Float("hr5ic谐波畸变率"))

    hr7ia: float = Opt(Float("hr7ia谐波畸变率"))
    hr7ib: float = Opt(Float("hr7ib谐波畸变率"))
    hr7ic: float = Opt(Float("hr7ic谐波畸变率"))

    hr9ia: float = Opt(Float("hr9ia谐波畸变率"))
    hr9ib: float = Opt(Float("hr9ib谐波畸变率"))
    hr9ic: float = Opt(Float("hr9ic谐波畸变率"))

    hr11ia: float = Opt(Float("hr11ia谐波畸变率"))
    hr11ib: float = Opt(Float("hr11ib谐波畸变率"))
    hr11ic: float = Opt(Float("hr11ic谐波畸变率"))

    hr13ia: float = Opt(Float("hr13ia谐波畸变率"))
    hr13ib: float = Opt(Float("hr13ib谐波畸变率"))
    hr13ic: float = Opt(Float("hr13ic谐波畸变率"))


@dataclass
class VoltageHarmonic(Model):
    """电压谐波分量"""
    thdua: list = Opt(List('a相电压总谐波畸变率').items(Float()))
    thdub: list = Opt(List('b相电压总谐波畸变率').items(Float()))
    thduc: list = Opt(List('c相电压总谐波畸变率').items(Float()))
    thduab: list = Opt(List('ab相电压总谐波畸变率').items(Float()))
    thducb: list = Opt(List('cb相电压总谐波畸变率').items(Float()))

    hr3ua: list = Opt(List('a相电压3次谐波畸变率').items(Float()))
    hr3ub: list = Opt(List('b相电压3次谐波畸变率').items(Float()))
    hr3uc: list = Opt(List('c相电压3次谐波畸变率').items(Float()))
    hr3uab: list = Opt(List('ab相电压3次谐波畸变率').items(Float()))
    hr3ucb: list = Opt(List('cb相电压3次谐波畸变率').items(Float()))

    hr5ua: list = Opt(List('a相电压5次谐波畸变率').items(Float()))
    hr5ub: list = Opt(List('b相电压5次谐波畸变率').items(Float()))
    hr5uc: list = Opt(List('c相电压5次谐波畸变率').items(Float()))
    hr5uab: list = Opt(List('ab相电压5次谐波畸变率').items(Float()))
    hr5ucb: list = Opt(List('cb相电压5次谐波畸变率').items(Float()))

    hr7ua: list = Opt(List('a相电压7次谐波畸变率').items(Float()))
    hr7ub: list = Opt(List('b相电压7次谐波畸变率').items(Float()))
    hr7uc: list = Opt(List('c相电压7次谐波畸变率').items(Float()))
    hr7uab: list = Opt(List('ab相电压7次谐波畸变率').items(Float()))
    hr7ucb: list = Opt(List('cb相电压7次谐波畸变率').items(Float()))

    hr9ua: list = Opt(List('a相电压9次谐波畸变率').items(Float()))
    hr9ub: list = Opt(List('b相电压9次谐波畸变率').items(Float()))
    hr9uc: list = Opt(List('c相电压9次谐波畸变率').items(Float()))
    hr9uab: list = Opt(List('ab相电压9次谐波畸变率').items(Float()))
    hr9ucb: list = Opt(List('cb相电压9次谐波畸变率').items(Float()))

    hr11ua: list = Opt(List('a相电压11次谐波畸变率').items(Float()))
    hr11ub: list = Opt(List('b相电压11次谐波畸变率').items(Float()))
    hr11uc: list = Opt(List('c相电压11次谐波畸变率').items(Float()))
    hr11uab: list = Opt(List('ab相电压11次谐波畸变率').items(Float()))
    hr11ucb: list = Opt(List('cb相电压11次谐波畸变率').items(Float()))

    hr13ua: list = Opt(List('a相电压13次谐波畸变率').items(Float()))
    hr13ub: list = Opt(List('b相电压13次谐波畸变率').items(Float()))
    hr13uc: list = Opt(List('c相电压13次谐波畸变率').items(Float()))
    hr13uab: list = Opt(List('ab相电压13次谐波畸变率').items(Float()))
    hr13ucb: list = Opt(List('cb相电压13次谐波畸变率').items(Float()))


@dataclass
class CurrentHarmonic(Model):
    """电流谐波分量"""
    fdia: list = Opt(List('a相基波电流').items(Float()))
    fdib: list = Opt(List('b相基波电流').items(Float()))
    fdic: list = Opt(List('c相基波电流').items(Float()))

    thdia: list = Opt(List('a相电流总谐波畸变率').items(Float()))
    thdib: list = Opt(List('b相电流总谐波畸变率').items(Float()))
    thdic: list = Opt(List('c相电流总谐波畸变率').items(Float()))

    hr3ia: list = Opt(List('a相电流3次谐波畸变率').items(Float()))
    hr3ib: list = Opt(List('b相电流3次谐波畸变率').items(Float()))
    hr3ic: list = Opt(List('c相电流3次谐波畸变率').items(Float()))

    hr5ia: list = Opt(List('a相电流5次谐波畸变率').items(Float()))
    hr5ib: list = Opt(List('b相电流5次谐波畸变率').items(Float()))
    hr5ic: list = Opt(List('c相电流5次谐波畸变率').items(Float()))

    hr7ia: list = Opt(List('a相电流7次谐波畸变率').items(Float()))
    hr7ib: list = Opt(List('b相电流7次谐波畸变率').items(Float()))
    hr7ic: list = Opt(List('c相电流7次谐波畸变率').items(Float()))

    hr9ia: list = Opt(List('a相电流9次谐波畸变率').items(Float()))
    hr9ib: list = Opt(List('b相电流9次谐波畸变率').items(Float()))
    hr9ic: list = Opt(List('c相电流9次谐波畸变率').items(Float()))

    hr11ia: list = Opt(List('a相电流11次谐波畸变率').items(Float()))
    hr11ib: list = Opt(List('b相电流11次谐波畸变率').items(Float()))
    hr11ic: list = Opt(List('c相电流11次谐波畸变率').items(Float()))

    hr13ia: list = Opt(List('a相电流13次谐波畸变率').items(Float()))
    hr13ib: list = Opt(List('b相电流13次谐波畸变率').items(Float()))
    hr13ic: list = Opt(List('c相电流13次谐波畸变率').items(Float()))


@dataclass
class ElecHistoryResponse(Model):
    """用电监测-实时监测-历史曲线"""
    ctnum: int = Int('二表法 | 三表法').eg(3)
    lf: list = List('负载率').items(Float())
    power: Power = Power
    costtl: list = List('功率因数').items(Float())
    u: U = U
    i: I = I
    freq: list = List('频率').items(Float())
    time_slots: list = List('时间轴').items(Str('时间'))
    sdu_i: str = Opt(Str('识电U具体的电流项: ia/ib/ic'))
    sdu_u: str = Opt(Str('识电U具体的电压项: ua/ub/uc/uab/ucb'))


@dataclass
class ElecCurrentResponse(Model):
    """用电监测-实时监测-实时参数"""
    ctnum: int = Opt(Int('二表法 | 三表法').eg(3))
    real_time: DateTime = DateTime
    ua: float = Opt(Float("ua电压实时数值"))
    ub: float = Opt(Float("ub电压实时数值"))
    uc: float = Opt(Float("uc电压实时数值"))
    uab: float = Opt(Float("uab电压实时数值"))
    ucb: float = Opt(Float("ucb电压实时数值"))
    ia: float = Opt(Float("ia电流实时数值"))
    ib: float = Opt(Float("ib电流实时数值"))
    ic: float = Opt(Float("ic电流实时数值"))
    pttl: float = Opt(Float("有功实时数值"))
    qttl: float = Opt(Float("无功实时数值"))
    freq: float = Opt(Float("频率实时数值"))
    costtl: float = Opt(Float("功率因数"))
    lf: float = Opt(Float("负载率实时数值"))
    sdu_i: str = Opt(Str('识电U具体的电流项: ia/ib/ic'))
    sdu_u: str = Opt(Str('识电U具体的电压项: ua/ub/uc/uab/ucb'))
    # 增加电压偏差,用于判断是否超过阈值标红
    ua_dev: float = Opt(Float("电压偏差"))
    ub_dev: float = Opt(Float("电压偏差"))
    uc_dev: float = Opt(Float("电压偏差"))
    uab_dev: float = Opt(Float("电压偏差"))
    ucb_dev: float = Opt(Float("电压偏差"))
    freq_dev: float = Opt(Float("频率偏差实时数值"))


@dataclass
class ElecIndex(Model):
    stats_index: str = Str('index.type[P(kW)|Q(kVar)|Ua(kW)]').eg("P(kW)")
    max: float = Float('最大值')
    max_time: DateTime = DateTime
    min: float = Float('最小值')
    min_time: DateTime = DateTime
    avg: float = Float('平均值')
    name: str = Opt(Str('指标值名称'))


@dataclass
class ElecIndexResponse(Model):
    """指标统计-常规参数+电能质量"""
    ctnum: int = Opt(Int('二表法 | 三表法').eg(3))
    common_indexes: list = Opt(List('常规参数统计列表').items(ElecIndex))
    elec_qual_indexes: list = Opt(List('电能质量统计列表').items(ElecIndex))


@dataclass
class QualHistoryResponse(Model):
    """电能质量-历史曲线"""
    ctnum: int = Int('二表法 | 三表法').eg(3)
    voltage_dev: VoltageDev = VoltageDev
    freq_dev: list = List('频率偏差').items(Float())
    three_phase_unbalance: ThreePhaseImbalance = ThreePhaseImbalance
    voltage_harmonic: VoltageHarmonic = VoltageHarmonic
    current_harmonic: CurrentHarmonic = CurrentHarmonic
    time_slots: list = List('时间轴').items(Str('时间'))
    sdu_i: str = Opt(Str('识电U具体的电流项: ia/ib/ic'))
    sdu_u: str = Opt(Str('识电U具体的电压项: ua/ub/uc/uab/ucb'))


@dataclass
class QualCurrentResponse(Model):
    """电能质量-实时参数"""
    ctnum: int = Opt(Int('二表法 | 三表法').eg(3))
    real_time: DateTime = DateTime
    health_index: int = Opt(Float('用电健康指数').eg(94))
    ua_dev: float = Opt(Float("ua电压偏差实时数值"))
    ub_dev: float = Opt(Float("ub电压偏差实时数值"))
    uc_dev: float = Opt(Float("uc电压偏差实时数值"))
    uab_dev: float = Opt(Float("uab电压偏差实时数值"))
    ucb_dev: float = Opt(Float("ucb电压偏差实时数值"))
    freq_dev: float = Opt(Float("频率偏差实时数值"))
    ubl: float = Opt(Float("电压三相不平衡度"))
    ibl: float = Opt(Float("电流三相不平衡度"))
    voltage_harmonic: VoltageHarmonicRate = Opt(VoltageHarmonicRate)
    current_harmonic: CurrentHarmonicRate = Opt(CurrentHarmonicRate)
    sdu_i: str = Opt(Str('识电U具体的电流项: ia/ib/ic'))
    sdu_u: str = Opt(Str('识电U具体的电压项: ua/ub/uc/uab/ucb'))


elec_history_example = {
    "范例1": {
        "filter": {
            "equals": [
                {
                    "field": "point_id",
                    "value": 53
                }
            ],
            "ranges": [
                {
                    "field": "datetime",
                    "start": "2020-07-30 00:00:00",
                    "end": "2020-07-30 23:59:59"
                }
            ]
        }
    }
}

elec_current_example = {
    "范例1": {
        "filter": {
            "equals": [
                {
                    "field": "point_id",
                    "value": 53
                }
            ],
            "ranges": [],
            "in_groups": []
        }
    }
}

elec_index_example = {
    "范例1": {
        "filter": {
            "equals": [
                {
                    "field": "point_id",
                    "value": 53
                }
            ],
            "ranges": [
                {
                    "field": "datetime",
                    "start": "2020-07-30 00:00:00",
                    "end": "2020-07-30 23:59:59"
                }
            ]
        },
        "sort": {
            "field": "datetime",
            "direction": "desc"
        }
    }
}

qual_history__example = {
    "范例1": {
        "filter": {
            "equals": [
                {
                    "field": "point_id",
                    "value": 53
                }
            ],
            "ranges": [
                {
                    "field": "datetime",
                    "start": "2020-07-30 00:00:00",
                    "end": "2020-07-30 23:59:59"
                }
            ]
        }
    }
}

qual_current_example = {
    "范例1": {
        "cid": 43,
        "filter": {
            "equals": [
                {
                    "field": "point_id",
                    "value": 53
                }
            ],
            "ranges": [],
            "in_groups": []
        }
    }
}


@dataclass
class EcsReq(Model):
    cid: Cid
    storeys: list = List("楼层列表").eg([1, 2, 3])
    product: int = Int("product 1-知电 2-安电 3-安电管理 4-识电U").eg(4)


@dataclass
class EscResp(Model):
    elec_data: list = List("用电监测").eg(
        [{"name": "89栋", "room_data": [{"key1": 10}, {"key2": 11}]}]
    )


@dataclass
class QcsResp(Model):
    qual_data: list = List("电能质量").eg(
        [{"name": "89栋", "room_data": [{"key1": 10}, {"key2": 11}]}]
    )


@dataclass
class EclResp(Model):
    inline: list = List("进线").eg([])
    transformer: list = List("变压器").eg([])
    feeder: list = List("馈线").eg([])
    power_dist: list = List("配电").eg([])
    device: list = List("设备级").eg([])


@dataclass
class QclResp(Model):
    inline: list = List("进线").eg([])
    transformer: list = List("变压器").eg([])
    feeder: list = List("馈线").eg([])
    power_dist: list = List("配电").eg([])
    device: list = List("设备级").eg([])