from dataclasses import dataclass

from pot_libs.sanic_api import Model
from pot_libs.sanic_api.column import Str, Int, Opt


@dataclass
class StatisProxyReq(Model):
    date_type: str = Str("时间类型->day/month/year/range").eg("day")
    start: str = Str("开始时间").eg("2020-07-30 00:00:00")
    end: str = Str("结束时间").eg("2020-07-30 23:59:59")
    cid: int = Opt(Int("id").eg("1"))
    proxy_id: int = Opt(Int("代理id").eg("1"))
