# -*- coding:utf-8 -*-
"""
DATE：2024/5/30 11:34

"""
from pot_libs.logger import log
from unify_api.constants import E_TYPE_MSG_LANG, PHASE_LINE_LANG, E_TYPE_NAME_LANG


def load_event_msg(e_type, event_param, lang):
    if not event_param:
        return ""

    msg_fmt = E_TYPE_MSG_LANG.get(e_type, {}).get(lang)
    if not msg_fmt:
        return ""

    return msg_fmt.format(**event_param)


def load_phase_line(mtr_name, lang):
    lst = []
    try:
        lst = mtr_name.split("_")
    except Exception as e:
        log.error(f"load_phase_line error, mtr_name:{mtr_name}, {e}")
    finally:
        if len(lst) > 1:
            return PHASE_LINE_LANG.get(lst[-1], {}).get(lang)

        return ""


def load_e_type_name(e_type, lang="zh_CN"):
    return E_TYPE_NAME_LANG.get(e_type, {}).get(lang, "")
