from pot_libs.sanic_api import summary
from unify_api.modules.zhiwei_u.components.data_operations_cps import *
from unify_api.modules.zhiwei_u.service.data_operation_service import *


# 数据查询模块
@summary('数据查询')
async def post_data_operation_search(req, body: DataOperationSearchReq) -> \
        DataOperationSearchResp:
    mtid = body.mtid
    point = body.point
    params = body.params
    start = body.start
    end = body.end
    return await data_operation_search_service(mtid, point, params, start, end)


@summary('根据sid pid返回参数')
async def post_sid_to_params(req, body: SidToParamsReq) -> \
        ParamsResp:
    sid = body.sid
    pid = body.pid
    return await sid_to_params_service(sid, pid)


@summary('根据mtid 返回基本信息')
async def post_mtid_to_info(req, body: MtidToInfoReq) -> \
        MtidToInfoResp:
    mtid = body.mtid
    return await mtid_to_info_service(mtid)


@summary('下载数据查询 excel')
async def get_download_data_opeartions(req):
    mtid = req.args.get("mtid")
    point = req.args.get("point")
    params = req.args.get("params")
    params = params.split(",")
    start = req.args.get("start")
    end = req.args.get("end")
    user_id = req.ctx.user_id
    download = 1
    return await data_operation_search_service(mtid, point, params, start,
                                               end, download, user_id)
