# /usr/bin/env python
# -*- coding: UTF-8 -*-
import numpy as np


def break_inside(conv_data,ctnum):
    if ctnum == 2:
        flag_a = 0
        flag_c = 0
        if np.mean(conv_data['iab'])<0.000001 and np.mean(conv_data['uab']) > 30:
            flag_a=1
        if np.mean(conv_data['ibc'])<0.000001 and np.mean(conv_data['ubc']) > 30:
            flag_c=1

        if flag_a == 1 and flag_c==1:
            return 4, u'两相断线AC', u'内部故障'
        elif flag_a==1:
            return 4, u'单相断线A', u'内部故障'
        elif flag_c==1:
            return 4, u'单相断线C', u'内部故障'
        else:
            return 0, 'E', u'内部无故障'
    else:
        flag_a = 0
        flag_b = 0
        flag_c = 0
        if np.mean(conv_data['ia']) < 0.000001 and np.mean(conv_data['ua']) > 30:
            flag_a = 1
        if np.mean(conv_data['ib']) < 0.000001 and np.mean(conv_data['ub']) > 30:
            flag_b = 1
        if np.mean(conv_data['ic']) < 0.000001 and np.mean(conv_data['uc']) > 30:
            flag_c = 1

        if flag_a == 1 and flag_c == 1 and flag_b==1:
            return 4, u'三相断线ABC', u'内部故障'
        elif flag_a == 1 and flag_b==1:
            return 4, u'两相断线AB', u'内部故障'
        elif flag_c == 1 and flag_a==1:
            return 4, u'两相断线AC', u'内部故障'
        elif flag_a==1:
            return 4, u'单相断线A', u'内部故障'
        elif flag_b==1:
            return 4, u'单相断线B', u'内部故障'
        elif flag_c==1:
            return 4, u'单相断线C', u'内部故障'
        else:
            return 0, 'E', u'内部无故障'


def break_outside(conv_data,ctnum):
    if ctnum == 2:
        flag_a = 0
        flag_c = 0
        if np.mean(conv_data['iab'])<0.000001 and np.mean(conv_data['uab']) < 10:
            flag_a=1
        if np.mean(conv_data['ibc'])<0.000001 and np.mean(conv_data['ubc']) < 10:
            flag_c=1

        if flag_a == 1 and flag_c==1:
            return 4, u'两相断线AC', u'外部故障'
        elif flag_a==1:
            return 4, u'单相断线A', u'外部故障'
        elif flag_c==1:
            return 4, u'单相断线C', u'外部故障'
        else:
            return 0, 'E', u'外部无故障'
    else:
        flag_a = 0
        flag_b = 0
        flag_c = 0
        if np.mean(conv_data['ia']) < 0.000001 and np.mean(conv_data['ua']) < 10:
            flag_a = 1
        if np.mean(conv_data['ib']) < 0.000001 and np.mean(conv_data['ub']) < 10:
            flag_b = 1
        if np.mean(conv_data['ic']) < 0.000001 and np.mean(conv_data['uc']) < 10:
            flag_c = 1

        if flag_a == 1 and flag_c == 1 and flag_b==1:
            return 4, u'三相断线ABC', u'外部故障'
        elif flag_a == 1 and flag_b==1:
            return 4, u'两相断线AB', u'外部故障'
        elif flag_c == 1 and flag_a==1:
            return 4, u'两相断线AC', u'外部故障'
        elif flag_a==1:
            return 4, u'单相断线A', u'外部故障'
        elif flag_b==1:
            return 4, u'单相断线B', u'外部故障'
        elif flag_c==1:
            return 4, u'单相断线C', u'外部故障'
        else:
            return 0, 'E', u'外部无故障'