from dataclasses import dataclass

from pot_libs.common.components.fields import Cid
from pot_libs.sanic_api import Model
from pot_libs.sanic_api.column import Float, List, Str, Opt, Int, Dict
from unify_api.utils.response_code import DbErr


@dataclass
class PvEvaluateReq(Model):
    cid: int = Int("cid").eg(45)
    start: str = Str("开始时间").eg("2019-05")
    end: str = Str("结束时间").eg("2019-12")


@dataclass
class PvEvaluateComputeReq(Model):
    cid: int = Int("cid").eg(45)
    start: str = Str("开始时间").eg("2019-05")
    end: str = Str("结束时间").eg("2019-12")
    area_conversion_ratio: float = Float("面积折算系数").eg(0.8)
    capacity_per_meter: float = Float("单位面积容量").eg(100)
    install_space: float = Float("场地面积").eg(1000)
    self_use_ratio: float = Float("自用比例").eg(1)
    internet_ratio: float = Float("上网比例").eg(0)
    efficiency: float = Float("光伏发电效率").eg(0.80)
    evaluate_year: int = Int("发电年限").eg(25)
    rmb_per_w: float = Float("建设单价").eg(4.3)
    maintenance_per_wp: float = Float("维护成本").eg(0.05)
    coal_in_grid: float = Float("上网电价").eg(0.45)


@dataclass
class PvEvaluateResp(Model):
    rule: int = Opt(Int("一充一放:1、两充两放:2").eg(1))
    sum_kwh_p: float = Float("峰值总耗电量").eg(1)
    electrovalence: dict = Dict("电价时段").eg({"v": ["01:00"]})
    slot: list = List("时间").eg(["00:00", "01:00"])
    p: list = List("负荷").eg(["12", "13"])
    kwh: list = List("电量").eg(["1", "2"])


@dataclass
class PvEvaluateTwoResp(Model):
    rule: int = Opt(Int("一充一放:1、两充两放:2").eg(1))
    sum_kwh_p: float = Float("峰时段总耗电量").eg(1)
    sum_kwh_s: float = Opt(Float("尖时段总耗电量").eg(1))
    electrovalence: dict = Dict("电价时段").eg({"v": ["01:00"]})
    kwh_slot: list = List("电量时间").eg(["00:00", "01:00"])
    p_slot: list = List("负荷时间").eg(["00:00", "01:00"])
    p: list = List("负荷").eg(["12", "13"])
    kwh: list = List("电量").eg(["1", "2"])


@dataclass
class Optimizecurve(Model):
    """光伏优化曲线"""
    slot: list = List('slot').items(Str())
    before_curve: list = List('优化前').items(Float())
    after_curve: list = List('优化后').items(Float())
    pv_curve: list = List('pv_curve').items(Float())


@dataclass
class ComputeTable(Model):
    """光伏测算表"""
    slot: list = List('年份').items(Int())
    year_attenuation: list = List('年衰减值').items(Float())
    surplus_capacity: list = List('剩余容量').items(Float())
    year_add_electric: list = List('年发电量').items(Float())
    wp_rmb: list = List('维护成本').items(Float())
    all_rmb: list = List('累计总成本').items(Float())
    this_year_earnings: list = List('本年收益').items(Float())
    all_earnings: list = List('累计收益').items(Float())


@dataclass
class PvEvaluateComputeResp(Model):
    optimize_curve: Optimizecurve = Optimizecurve   # 优化曲线
    compute_table: list = List('测算表')  # 测算表
    invest_capacity: float = Float("装机容量").eg(1000.123)
    first_year_kwh: float = Float("首年发电量").eg(1000.123)
    static_period: float = Float("回收周期").eg(1000.123)
    total_capacity: float = Float("建设面积").eg(1000.123)
    invest_charge: float = Float("建设投资").eg(1000.123)
    c_emissions: float = Float("首年碳减排").eg(1000.123)
    co2_emissions: float = Float("首年co2减排").eg(1000.123)
    year_earnings: float = Float("预期年收益").eg(1000.123)
    all_c_emissions: float = Float("累计碳减排").eg(1000.123)
    tree: int = Int("植树").eg(1000)
    download_url: str = Str("下载连接").eg("")


@dataclass
class EssEvaluateReq (Model):
    cid: int = Int("cid").eg(45)
    start: str = Str("开始时间").eg("2019-05")
    end: str = Str("结束时间").eg("2019-12")
    work_day: int = Int("1 全部 2工作日 3非工作日").eg(1)


@dataclass
class EssEvaluateComputeReq(Model):
    cid: int = Int("cid").eg(45)
    start: str = Str("开始时间").eg("2019-05")
    end: str = Str("结束时间").eg("2019-12")
    rule: int = Int("一充一放:1、两充两放:2").eg(1)
    install_capacity: float = Float("储能容量").eg(1000)
    pcs_type: float = Float("pcs类型").eg(123)
    decay_rate: float = Float("衰减率").eg(0.03)
    DOD: float = Float("放电深度").eg(0.9)
    year_use_days: int = Int("年利用天数").eg(330)
    maintenance_ratio_per_year: float = Float("运维费用占静态投资比例").eg(0.03)
    subsidy_year: int = Int("补贴年限").eg(10)
    epc_price: float = Float("建设单价").eg(1.4)
    kwh_subsidy: float = Float("度电补贴").eg(0)


@dataclass
class OptCurve(Model):
    """储能优化曲线"""
    slot: list = List('slot').items(Str())
    load_curve: list = List('load_curve').items(Float())
    bat_curve: list = List('bat_curve').items(Float())
    load_bat_curve: list = List('load_bat_curve').items(Float())


# @dataclass
# class EssComputeTable(Model):
#     """储能测算表"""
#     slot: list = List('年份').items(Int())
#     surplus_capacity: list = List('剩余容量').items(Float())
#     count_num: list = List('累计充放数').items(Float())
#     earnings: list = List('充放电收益').items(Float())
#     wp_rmb: list = List('维护成本').items(Float())
#     all_rmb: list = List('累计总成本').items(Float())
#     this_year_earnings: list = List('本年收益').items(Float())
#     all_earnings: list = List('累计收益').items(Float())


@dataclass
class EssEvaluateComputeResp(Model):
    evaluate_table: OptCurve = OptCurve
    ess_compute_table: list = List('测算表')  # 测算表
    invest_capacity: float = Float("储能容量").eg(1000.123)
    static_period: int = Int("回收期").eg(10)
    pcs_capacity: float = Float("PCS选型").eg(1000)
    month_average_dc_kwh: float = Float("月削峰电量").eg(1000.123)
    month_dc_benefit: float = Float("预期价差收益").eg(1000.123)
    download_url: str = Str("download_url").eg("")


@dataclass
class ElectrovalenceSettingReq(Model):
    cid: int = Int("cid").eg(45)
    price_md: float = Float("需量单价").eg(35)
    price_tc: float = Float("容量单价").eg(23)
    std_cos: float = Float("力调电费").eg(0.85)
    electrovalence: list = List("电镀电费").eg([{
        "name": "s", "price": "0.123", "slot": [["12:00", "13:00"]]}])


@dataclass
class ElectrovalenceReq(Model):
    cid: int = Int("cid").eg(45)


@dataclass
class ElectrovalenceResp(Model):
    price_md: float = Float("需量单价").eg(1000.123)
    price_tc: float = Float("容量单价").eg(1000.123)
    std_cos: float = Float("力调电费").eg(1000.123)
    electrovalence: list = List("电度电费:s尖,p峰,f平,v谷").eg([{
        "name": "s", "price": "0.123", "slot": ["12:00-13:00"]}])

