import sys
import json
import pytest
sys.path.append(f'/home/ubuntu/data/code/unify_api2/pot_libs')
sys.path.append(f'/home/ubuntu/data/code/unify_api2')
from unify_api.tests.constants_t import TOKEN, HTTP_PREFIX
from pot_libs.aiohttp_util.aiohttp_utils import AioHttpUtils


@pytest.mark.parametrize('data', [
    {
        "id": "QK0000000001"
    },
])
@pytest.mark.asyncio
async def test_post_box_lock(data):
    """根据id获取锁secret_key,password"""
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/ulock/lock/box-lock",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    resp_str = json.loads(resp_str)
    assert resp_str["data"]["secret_key"] and resp_str["data"]["password"]
    assert status == 200


@pytest.mark.parametrize('data', [
    {
        "mac": "100270200483779D4D4D3200"
    },
])
@pytest.mark.asyncio
async def test_post_lock_id(data):
    """根据mac获取id"""
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/ulock/lock/lock-id",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    resp_str = json.loads(resp_str)
    assert resp_str["data"]["id"]
    assert status == 200
