import json
import pytest
from unify_api.tests.constants_t import post_request


class TestListPoint(object):
    url = "/unify-api/common/list-point/list-point"

    @pytest.mark.parametrize('data', [
        {"cid": 117}, {"cid": 118}, {"cid": 44}, {"cid": -100000}
    ])
    @pytest.mark.asyncio
    async def test_list_point_true(self, data):
        resp_str, status = await post_request(self.url, data)
        assert status == 200
        resp_dict = json.loads(resp_str)
        assert ("inlines" in resp_dict["data"]) is True

    @pytest.mark.parametrize('data', [{"cid": "117"}, {"cid": ""}])
    @pytest.mark.asyncio
    async def test_list_tsp_point_false(self, data):
        resp_str, status = await post_request(self.url, data)
        assert status == 400


@pytest.mark.parametrize('data', [
    {
       "cid": 118,
    },
])
@pytest.mark.asyncio
async def test_list_storey(data):
    """
    获取监测点,进线列表
    """
    url = "/unify-api/common/list-point/list-storey"
    resp_str, status = await post_request(url, data)
    assert status == 200
    resp_str = json.loads(resp_str)
    assert len(resp_str["data"]["storey_list"]) == 0


@pytest.mark.parametrize('data', [
    {
       "cid": 118,
    }, {
       "cid": 44,
    },
])
@pytest.mark.asyncio
async def test_list_point_level(data):
    """
    获取监测点,进线列表
    """
    url = "/unify-api/common/list-point/list-point-level"
    resp_str, status = await post_request(url, data)
    assert status == 200
    resp_str = json.loads(resp_str)
    assert resp_str["data"]["power_show_all"]


@pytest.mark.parametrize('data', [
    {
       "cid": 118,
    },
])
@pytest.mark.asyncio
async def test_list_point_inline(data):
    """
    获取监测点,进线列表
    """
    url = "/unify-api/common/list-point/list-point-inline"
    resp_str, status = await post_request(url, data)

    assert status == 200
    resp_str = json.loads(resp_str)
    assert resp_str["data"]["inlines"][0]["inline_id"]


class TestListTspPoint(object):
    url = "/unify-api/common/list-point/list-tsp-point"

    @pytest.mark.parametrize('data', [
        {"cid": 117}, {"cid": 100000}, {"cid": -100000}
    ])
    @pytest.mark.asyncio
    async def test_list_tsp_point_true(self, data):
        resp_str, status = await post_request(self.url, data)
        assert status == 200
        resp_dict = json.loads(resp_str)
        assert ("tsp_list" in resp_dict["data"]) is True

    @pytest.mark.parametrize('data', [{"cid": "117"}, {"cid": ""}])
    @pytest.mark.asyncio
    async def test_list_tsp_point_false(self, data):
        resp_str, status = await post_request(self.url, data)
        assert status == 400
