import json
import pytest
import requests
from unify_api.tests.constants_t import TOKEN, HTTP_PREFIX
from pot_libs.aiohttp_util.aiohttp_utils import AioHttpUtils


@pytest.mark.asyncio
async def test_post_json_request_includes_data():

    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/qk-website/apply-trial/apply-trial",
        data={}, timeout=10
    )
    print(resp_str)
    print(status)
    assert status == 200


class TestPage:
    @pytest.mark.asyncio
    def test_qk(self):
        resp = requests.get(f"{HTTP_PREFIX}/unify-api/qk-website/apply-trial/page-data")
        print(resp.status_code)
        print(resp.content)

    def test_qk2(self):
        resp = requests.post(f"{HTTP_PREFIX}/unify-api/qk-website/apply-trial/apply-trial")
        print(resp.status_code)
        print(json.loads(resp.text))