from pot_libs.sanic_api import summary
from unify_api.modules.zhiwei_u.components.scope_operations_cps import \
    SearchScopeRep, SearchScopeResq, ScopeDetailRep
from unify_api.modules.zhiwei_u.service.scope_operations_service import *


# 录波查询
@summary('录波查询')
async def post_search_scope(req, body: SearchScopeRep) -> SearchScopeResq:
    prod_id = body.prod_id
    cid = body.cid
    pid = body.pid
    start = body.start
    end = body.end
    sid = body.sid
    page_size = body.page_size
    page_num = body.page_num
    return await search_scope_service(prod_id, cid, pid, sid, page_num,
                                      page_size, start, end)


@summary('录波查询-详情')
async def post_scope_detai1(req, body: ScopeDetailRep) -> SearchScopeResq:
    id = body.id
    wave_range = body.wave_range
    return await scope_detail_service(id, wave_range)


@summary('录波查询-下载')
async def get_download_scope(req):
    id = req.args.get("id")
    user_id = req.ctx.user_id
    download = 1
    return await scope_detail_service(id, "all", download, user_id)

