from pot_libs.logger import log
from pot_libs.mysql_util.mysql_util import MysqlUtil


async def insert_user_info(real_name, unit, job, password, phone,
                           wechat_id=None):
    """用户表  插入数据"""
    sql = """INSERT INTO `user` (`password`, `name`, `wechat_id`, `real_name`,
     `phone_number`, `unit`, `job`) VALUES ( %s, %s, %s, %s, %s, %s, %s); """
    async with MysqlUtil() as conn:
        await conn.execute(sql, args=(password, real_name, wechat_id,
                                      real_name, phone, unit, job))
        log.info(sql % (password, real_name, wechat_id,
                        real_name, phone, unit, job))


async def update_phone_dao(user_id, phone):
    """修改手机号码"""
    sql = "update user set phone_number = %s where user_id=%s and is_delete=0"
    async with MysqlUtil() as conn:
        await conn.execute(sql, args=(phone, user_id))
        log.info(sql % (phone, user_id))


async def update_userinfo_dao(user_id, alias, real_alias):
    sql = f"update user set {alias}=%s where user_id=%s and is_delete=0"
    log.info(sql % (real_alias, user_id))
    async with MysqlUtil() as conn:
        await conn.execute(sql, args=(real_alias, user_id))


async def update_user_auth_dao(user_id, sql):
    sql = f"update user set {sql} where user_id=%s and is_delete=0"
    log.info(sql % (user_id, ))
    async with MysqlUtil() as conn:
        await conn.execute(sql, args=(user_id,))


async def update_password_dao(phone, password):
    sql = f"update user set password=%s where phone_number=%s and is_delete=0"
    async with MysqlUtil() as conn:
        await conn.execute(sql, args=(password, phone))
        log.info(sql % (password, phone))


async def search_user_by_wechat_id_dao(wechat_id):
    sql = "select * from user where wechat_id = %s and is_delete=0"
    async with MysqlUtil() as conn:
        data = await conn.fetchone(sql, args=(wechat_id, ))
    return data


async def update_not_wechat(user_id, phone):
    sql = "update user set is_delete=1 where phone_number = %s " \
          "and wechat_id is null and user_id=%s and is_delete=0"
    async with MysqlUtil() as conn:
        await conn.execute(sql, args=(phone, user_id))
        log.info(sql % (phone, user_id))


async def update_not_phone(user_id, wechat_id):
    sql = "update user set is_delete=1 where wechat_id = %s " \
          "and phone_number is null and user_id=%s and is_delete=0"
    log.info(sql % (wechat_id, user_id))
    async with MysqlUtil() as conn:
        await conn.execute(sql, args=(wechat_id, user_id))


async def phone_is_having_dao(phone):
    sql = "select user_id,wechat_id from user where phone_number=%s " \
          "and is_delete=0"
    async with MysqlUtil() as conn:
        data = await conn.fetchone(sql, args=(phone,))
    return data


async def update_user_is_delete(user_id, wechat_id):
    sql = "update user set is_delete=1, wechat_id=%s " \
          "where user_id = %s and is_delete=0"
    log.info(sql % (wechat_id, user_id))
    async with MysqlUtil() as conn:
        await conn.execute(sql, args=(wechat_id, user_id))


async def search_user_product_auth_dao(user_id):
    sql = "select product,cid_ext,proxy,uassistant_auth" \
          " from user_product_auth where user_id = %s "
    async with MysqlUtil() as conn:
        data = await conn.fetchall(sql, args=(user_id, ))
    return data


async def search_product_auth_dao(user_id, product):
    sql = "select id from user_product_auth where user_id=%s and product=%s"
    async with MysqlUtil() as conn:
        data = await conn.fetchone(sql, args=(user_id, product))
    return data


async def update_product_auth_dao(product, cid_ext, user_id, proxy=None):
    if proxy:
        sql = "update user_product_auth set cid_ext=%s, proxy=%s " \
              "where user_id=%s and product=%s"
        log.info(sql % (cid_ext, proxy, user_id, product))
        async with MysqlUtil() as conn:
            await conn.execute(sql, args=(cid_ext, proxy, user_id, product))
    else:
        sql = "update user_product_auth set cid_ext=%s where user_id=%s and " \
              "product=%s"
        log.info(sql % (cid_ext, user_id, product))
        async with MysqlUtil() as conn:
            await conn.execute(sql, args=(cid_ext, user_id, product))


async def insert_product_auth_dao(user_id, product, cid_ext, proxy=None,
                                  uassistant_auth=None):
    import time
    created_time = int(time.time())
    sql = """INSERT INTO `user_product_auth` (`user_id`, `product`, `cid_ext`,
        `proxy`, `uassistant_auth`, created_time) VALUES ( %s, %s, %s, %s, %s,
         %s); """
    log.info(sql % (user_id, product, cid_ext, proxy, uassistant_auth,
                    created_time))
    async with MysqlUtil() as conn:
        await conn.execute(sql, args=(user_id, product, cid_ext,
                                      proxy, uassistant_auth, created_time))


async def is_having_wechat_id(wechat_id):
    sql = "select user_id from user where wechat_id = %s and is_delete=0"
    async with MysqlUtil() as conn:
        data = await conn.fetchone(sql, args=(wechat_id, ))
    return data


async def update_user_info(real_name, unit, job, passwd, phone, wechat_id):
    sql = "update user set real_name=%s, unit=%s, job=%s, password=%s, " \
          "wechat_id=%s where phone_number=%s and is_delete=0"
    log.info(sql % (real_name, unit, job, passwd, wechat_id, phone))
    async with MysqlUtil() as conn:
        await conn.execute(sql, args=(real_name, unit, job, passwd, wechat_id,
                                      phone))


async def update_user_info_by_wechat_id(real_name, unit, job, passwd, phone,
                                        wechat_id):
    sql = "update user set real_name=%s, unit=%s, job=%s, password=%s, " \
          "phone_number=%s where wechat_id=%s and is_delete=0"
    log.info(sql % (real_name, unit, job, passwd, wechat_id, phone))
    async with MysqlUtil() as conn:
        await conn.execute(sql, args=(real_name, unit, job, passwd, phone,
                                      wechat_id))
