from pot_libs.sanic_api import summary
from unify_api.modules.electric.components.proxy_health_cps import (
    ProxyHealthPageResp,
    ProxyHealthPageItem,
    ProxyHealthCountResp,
    HealthLevel,
    HealthProblem,
)
from unify_api.modules.electric.components.proxy_safe_cps import ProxyElectricPageReq
from unify_api.modules.electric.procedures.proxy_health_pds import (
    proxy_page_point_healths,
    proxy_health_sumarry,
)


@summary("安电u管理版本-用电健康-上方统计数据接口")
async def post_health_count_info(req, body: ProxyElectricPageReq) -> ProxyHealthCountResp:
    cids, month = body.cids, body.month
    count_info_map = await proxy_health_sumarry(cids, month)
    return ProxyHealthCountResp(
        total_point_cnt=count_info_map["total_point_cnt"],
        unqualified_point_cnt=count_info_map["unqualified_point_cnt"],
        health_level=HealthLevel(**count_info_map["health_level"]),
        health_problem=HealthProblem(**count_info_map["health_problem"]),
    )


@summary("安电u管理版-用电健康-获取月度列表数据")
async def post_health_list(req, body: ProxyElectricPageReq) -> ProxyHealthPageResp:
    cids, month = body.cids, body.month
    page_size, page_num = body.page_size, body.page_num

    sort_field = body.sort_field
    sort_direction = body.sort_direction
    health_info = await proxy_page_point_healths(
        cids, month, page_size, page_num, sort_field=sort_field, sort_direction=sort_direction
    )
    return ProxyHealthPageResp(
        total=health_info["total"], rows=[ProxyHealthPageItem(**i) for i in health_info["rows"]],
    )
