import pendulum

from pot_libs.settings import SETTING
from unify_api.constants import CST
from unify_api.modules.common.service.td_engine_service import \
    get_td_engine_data
from unify_api.utils.taos_new import parse_td_columns, td3_tbl_compate
from unify_api.utils.time_format import get_15min_ago


async def elec_current_data(mtids, cid):
    res_map = {}
    last_15min_time = get_15min_ago()
    url = f"{SETTING.stb_url}db_electric?tz=Asia/Shanghai"
    
    table_name = ["mt{}_ele".format(mtid) for mtid in mtids]
    td_tables = td3_tbl_compate(table_name)
    sql = f"select last_row(*) from electric_stb " \
          f"where TBNAME IN {td_tables} and ts >= '{last_15min_time}' " \
          f"group by tbname"
    is_succ, results = await get_td_engine_data(url, sql)
    if is_succ:
        head = parse_td_columns(results)
        for res in results["data"]:
            data = dict(zip(head, res))
            if data["mtid"] in mtids:
                res_map[data["mtid"]] = data
    return res_map


def trans_electric_tdengine_data(results):
    head = parse_td_columns(results)
    if not results["data"]:
        results["data"] = ['' for i in range(len(head))]
    res = dict(zip(head, results["data"][0]))
    return res
