from dataclasses import dataclass

from pot_libs.common.components.fields import Cid
from pot_libs.sanic_api import Model
from pot_libs.sanic_api.column import List, Str


@dataclass
class CidReq(Model):
    cid: Cid


@dataclass
class AcReq(Model):
    cid: Cid
    location_list: list = List().eg([988, 989, 990, 991, 992])


@dataclass
class CidPointsReq(Model):
    cid: Cid
    point_list: list = List().eg([439, 440, 441, 442, 443, 444, 445, 446, 447])


@dataclass
class LevelResp(Model):
    inline: list = List("进线").eg([])
    transformer: list = List("变压器").eg([])
    feeder: list = List("馈线").eg([])
    power_dist: list = List("配电").eg([])
    device: list = List("设备级").eg([])


@dataclass
class CidStartEndReq(Model):
    cid: Cid
    start: str = Str("开始时间").eg("2021-06-01 00:00:00")
    end: str = Str("结束时间").eg("2021-06-30 23:59:59")
