import json
import pytest
from unify_api.tests.constants_t import post_request, get_request


#  来源
class TestWOrigin(object):
    url = "/unify-api/zhiwei-u/order-operations/w-origin"

    @pytest.mark.asyncio
    async def test_w_origin(self):
        resp_str, status = await get_request(self.url)
        assert status == 200


#  获取所有用户
class TestSearchAllUser(object):
    url = "/unify-api/zhiwei-u/order-operations/search-all-user"

    @pytest.mark.asyncio
    async def test_search_all_user(self):
        resp_str, status = await get_request(self.url)
        assert status == 200


#  接单
class TestReceiveOrder(object):
    url = "/unify-api/zhiwei-u/order-operations/receive-order"

    @pytest.mark.parametrize('data', [{"id": 40, "user_id": 88}])
    @pytest.mark.asyncio
    async def test_receive_order(self, data):
        resp_str, status = await post_request(self.url, data)
        assert status == 200
        resp_dict = json.loads(resp_str)
        assert resp_dict["data"]["success"] == 1

    @pytest.mark.parametrize('data', [{
        "id": 0, "user_id": 88}, {
        "id": 1000, "user_id": 88}
    ])
    @pytest.mark.asyncio
    async def test_receive_order_error_id(self, data):
        resp_str, status = await post_request(self.url, data)
        assert status == 200
        resp_dict = json.loads(resp_str)
        assert resp_dict["data"]["success"] == 0


#  转单  获取名单
class TestFlowOrderUser(object):
    url = "/unify-api/zhiwei-u/order-operations/flow-order-user"

    @pytest.mark.asyncio
    async def test_flow_order_user(self):
        resp_str, status = await get_request(self.url)
        assert status == 200
        resp_dict = json.loads(resp_str)
        assert isinstance(resp_dict["data"]["data"], list)


#  转单
class TestFlowOrder(object):
    url = "/unify-api/zhiwei-u/order-operations/flow-order"

    @pytest.mark.parametrize('data', [{
        "id": 30127, "myself_id": 88, "user_id": 10086, "doc_ids": [],
        "explain": "+++"}, {
        "id": 30126, "myself_id": 88, "doc_ids": [180], "user_id": 10086,
        "explain": ""}
    ])
    @pytest.mark.asyncio
    async def test_flow_order(self, data):
        resp_str, status = await post_request(self.url, data)
        assert status == 200
        resp_dict = json.loads(resp_str)
        assert resp_dict["data"]["success"] == 1

    @pytest.mark.parametrize('data', [{
        "id": 0, "myself_id": 88, "user_id": 10086, "doc_ids": [],
        "explain": "+++"}, {
        "id": 30129, "myself_id": 88, "user_id": 10086, "doc_ids": [],
        "explain": "+++"}, {
        "id": 30128, "myself_id": 88, "user_id": 88, "doc_ids": [],
        "explain": "+++"}
    ])
    @pytest.mark.asyncio
    async def test_flow_order_error_data(self, data):
        resp_str, status = await post_request(self.url, data)
        assert status == 200
        resp_dict = json.loads(resp_str)
        assert resp_dict["data"]["success"] == 0


#  处理工单
class TestWorkOrder(object):
    url = "/unify-api/zhiwei-u/order-operations/work-order"

    @pytest.mark.parametrize('data', [{
        "id": 40, "user_id": 88, "explain": "xxx", "doc_ids": [3]}, {
        "id": 40, "user_id": 88, "explain": "xxx", "doc_ids": []
    }])
    @pytest.mark.asyncio
    async def test_work_order(self, data):
        resp_str, status = await post_request(self.url, data)
        assert status == 200
        resp_dict = json.loads(resp_str)
        assert resp_dict["data"]["success"] == 1

    @pytest.mark.parametrize('data', [{
        "id": 1000, "user_id": 88, "explain": "xxx", "doc_ids": [3]}
    ])
    @pytest.mark.asyncio
    async def test_work_order_error_id(self, data):
        resp_str, status = await post_request(self.url, data)
        assert status == 200
        resp_dict = json.loads(resp_str)
        assert resp_dict["data"]["success"] == 0


#  关闭工单
class TestWCloseOrder(object):
    url = "/unify-api/zhiwei-u/order-operations/close-order"

    @pytest.mark.parametrize('data', [{
        "id": 40, "user_id": 88, "explain": "xxx", "doc_ids": [3]}, {
        "id": 41, "user_id": 88, "explain": "xxx", "doc_ids": []
    }])
    @pytest.mark.asyncio
    async def test_close_order(self, data):
        resp_str, status = await post_request(self.url, data)
        assert status == 200
        resp_dict = json.loads(resp_str)
        assert resp_dict["data"]["success"] == 1

    @pytest.mark.parametrize('data', [{
        "id": 1000, "user_id": 88, "explain": "xxx", "doc_ids": [3]}, {
        "id": 1000, "user_id": 100454, "explain": "xxx", "doc_ids": [3]}
    ])
    @pytest.mark.asyncio
    async def test_work_order_error_id(self, data):
        resp_str, status = await post_request(self.url, data)
        assert status == 200
        resp_dict = json.loads(resp_str)
        assert resp_dict["data"]["success"] == 0


#  录入工单  根据sid返回客户信息
class TestSidToOrder(object):
    url = "/unify-api/zhiwei-u/order-operations/sid-to-order"

    @pytest.mark.parametrize('data', [{"sid": "A1904000109"}])
    @pytest.mark.asyncio
    async def test_sid_to_order(self, data):
        resp_str, status = await post_request(self.url, data)
        assert status == 200
        resp_dict = json.loads(resp_str)
        assert isinstance(resp_dict["data"], dict)

    @pytest.mark.parametrize('data', [{"sid": "12345"}])
    @pytest.mark.asyncio
    async def test_sid_to_order_error_sid(self, data):
        resp_str, status = await post_request(self.url, data)
        assert status == 200
        resp_dict = json.loads(resp_str)
        assert resp_dict["data"]["success"] == 0


#  录入工单  根据监测点pid返回硬件编号sid
class TestPidToSid(object):
    url = "/unify-api/zhiwei-u/order-operations/pid-to-sid"

    @pytest.mark.parametrize('data', [{"pid": 60}, {"pid": 0}, {"pid": -10}])
    @pytest.mark.asyncio
    async def test_pid_to_sid(self, data):
        resp_str, status = await post_request(self.url, data)
        assert status == 200
        resp_dict = json.loads(resp_str)
        assert isinstance(resp_dict["data"], dict)


#  录入工单
class TestAddOrder(object):
    url = "/unify-api/zhiwei-u/order-operations/add-order"

    @pytest.mark.parametrize('data', [{
        "prod_id": 1, "cid": 32, "check_dt": "2021-04-22 00:00",
        "user_id": 88}, {
        "prod_id": 1, "cid": 32, "check_dt": "2021-04-22 00:00",
        "sid": "A1904000109", "user_id": 88}, {
        "prod_id": 1, "cid": 34, "check_dt": "2021-04-22 00:00",
        "point_id": 25, "user_id": 88}
    ])
    @pytest.mark.asyncio
    async def test_add_order(self, data):
        resp_str, status = await post_request(self.url, data)
        assert status == 200
        resp_dict = json.loads(resp_str)
        assert isinstance(resp_dict["data"], dict)

    @pytest.mark.parametrize('data', [{
        "prod_id": 1, "cid": 32, "check_dt": "2021-04-22 00:00",
        "sid": "A1904000109", "point_id": 25, "user_id": 88}
    ])
    @pytest.mark.asyncio
    async def test_add_order_error_params(self, data):
        resp_str, status = await post_request(self.url, data)
        assert status == 200
        resp_dict = json.loads(resp_str)
        assert resp_dict["data"]["success"] == 0


#  工单详情
class TestOrderDetail(object):
    url = "/unify-api/zhiwei-u/order-operations/order-detail"

    @pytest.mark.parametrize('data', [{"id": 45}])
    @pytest.mark.asyncio
    async def test_order_detail(self, data):
        resp_str, status = await post_request(self.url, data)
        assert status == 200
        resp_dict = json.loads(resp_str)
        assert isinstance(resp_dict["data"], dict)

    @pytest.mark.parametrize('data', [{"id": 0}, {"id": -1000}])
    @pytest.mark.asyncio
    async def test_order_detail_error_params(self, data):
        resp_str, status = await post_request(self.url, data)
        assert status == 200
        resp_dict = json.loads(resp_str)
        assert resp_dict["data"]["success"] == 0


#  工单详情 流程
class TestOrderDetailFlow(object):
    url = "/unify-api/zhiwei-u/order-operations/order-detail-flow"

    @pytest.mark.parametrize('data', [{"id": 45}])
    @pytest.mark.asyncio
    async def test_order_detail_flow(self, data):
        resp_str, status = await post_request(self.url, data)
        assert status == 200
        resp_dict = json.loads(resp_str)
        assert isinstance(resp_dict["data"], dict)

    @pytest.mark.parametrize('data', [{"id": 0}, {"id": -1000}])
    @pytest.mark.asyncio
    async def test_order_detail_error_params(self, data):
        resp_str, status = await post_request(self.url, data)
        assert status == 200
        resp_dict = json.loads(resp_str)
        assert resp_dict["data"]["success"] == 0
