import json
import pytest
import random
from unify_api.tests.constants_t import post_request, get_request


#  安装单管理-文件列表
class TestSheetList(object):
    url = "/unify-api/zhiwei-u/install-sheet/sheet-list"

    @pytest.mark.parametrize('data', [{"sid": 32, "product_id": 1},
                                      {"cid": 32, "product_id": 2},
                                      {"cid": -1000, "product_id": 3}])
    @pytest.mark.asyncio
    async def test_sheet_list(self, data):
        resp_str, status = await post_request(self.url, data)
        assert status == 200
        resp_dict = json.loads(resp_str)
        assert isinstance(resp_dict["data"]["customer"], list)


#  安装单管理-重命名
class TestSheetRename(object):
    url = "/unify-api/zhiwei-u/install-sheet/sheet-rename"

    @pytest.mark.parametrize('data', [{"sheet_id": 41, "user_id": 88}])
    @pytest.mark.asyncio
    async def test_sheet_rename(self, data):
        data["new_name"] = str(random.randint(100, 1000))
        resp_str, status = await post_request(self.url, data)
        assert status == 200
        resp_dict = json.loads(resp_str)
        assert resp_dict["code"] == 200

    @pytest.mark.parametrize('data', [
        {"sheet_id": 45, "new_name": "303", "user_id": 88},
        {"sheet_id": 0, "new_name": "303", "user_id": 88}
    ])
    @pytest.mark.asyncio
    async def test_sheet_rename_error(self, data):
        resp_str, status = await post_request(self.url, data)
        assert status == 200
        resp_dict = json.loads(resp_str)
        assert resp_dict["code"] == 5100
