import json
import pytest
from unify_api.tests.constants_t import TOKEN, HTTP_PREFIX
from pot_libs.aiohttp_util.aiohttp_utils import AioHttpUtils


@pytest.mark.parametrize('data', [
    {
        "cid": 73,
    },
    {
        "cid": 90,
    }
])
@pytest.mark.asyncio
async def test_health_index(data):
    """
    获取首页用电健康指数
    """
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/home-page/health-index"
            f"/health-index",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert resp_str["data"]["health_index"]


@pytest.mark.parametrize('data', [
    {
        "cid": 73,
    },
    {
        "cid": 90,
    }
])
@pytest.mark.asyncio
async def test_health_radar(data):
    """
    健康指数雷达评分
    """
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/home-page/health-index"
            f"/health-radar",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert all([resp_str["data"]["v_dev"], resp_str["data"]["ubl"],
                resp_str["data"]["freq_dev"], resp_str["data"]["costtl"],
                resp_str["data"]["thdu"], resp_str["data"]["lf"]])


@pytest.mark.parametrize('data', [
    {
        "cid": 90,
    }
])
@pytest.mark.asyncio
async def test_health_ctl_rate(data):
    """
    健康参数达标率
    """
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/home-page/health-index"
            f"/health-ctl-rate",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert all([resp_str["data"]["v_dev"], resp_str["data"]["ubl"],
                resp_str["data"]["freq_dev"], resp_str["data"]["costtl"],
                resp_str["data"]["thdu"], resp_str["data"]["lf"]])


@pytest.mark.parametrize('data', [
    {
        "product": 3
    },
])
@pytest.mark.asyncio
async def test_manage_health_index(data):
    """
    安电U管理版本
    管理版用电健康首页健康统计
    """
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/home-page/health-index"
            f"/manage-health-index",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert all([resp_str["data"]["excellent_cnt"],
                resp_str["data"]["good_cnt"]])


@pytest.mark.parametrize('data', [
    {"product": 6, "cid": 90},
    {"product": 6, "cid": 73},
])
@pytest.mark.asyncio
async def test_proxy_health_radar(data):
    """
    管理版本健康指数雷达评分
    """
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/home-page/health-index"
            f"/proxy-health-radar",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert all([resp_str["data"]["v_dev"], resp_str["data"]["ubl"],
                resp_str["data"]["freq_dev"], resp_str["data"]["costtl"],
                resp_str["data"]["thdu"], resp_str["data"]["lf"]])

