from dataclasses import dataclass

from pot_libs.common.components.fields import Cid
from pot_libs.sanic_api import Model
from pot_libs.sanic_api.column import Int, Str, List


@dataclass
class SlReq(Model):
    cid: Cid
    product_id: int = Int(
        '1-zhidianu,2-andianu,4-shidianu,6-intelligent-u').eg(1)


@dataclass
class SlResp(Model):
    customer: list = List("客户信息").eg([{
        "sheet_id": 1,
        "doc_name": "1.txt",
    }])
    hardware: list = List("硬件信息").eg([{
        "sheet_id": 1,
        "doc_name": "1.txt",
    }])


@dataclass
class SuResp(Model):
    sheet_id: int = Int("文件id").eg(1)
    doc_name: str = Str("文档名").eg("1.txt")
    belong: int = Int("属于信息").eg(0)


@dataclass
class SrReq(Model):
    sheet_id: int = Int("文件id").eg(1)
    new_name: str = Str("重命名").eg("1.txt")


@dataclass
class DrReq(Model):
    sheet_id_list: list = List("文件id列表").eg([84, 85])
