from dataclasses import dataclass

from pot_libs.common.components.fields import Cid
from pot_libs.sanic_api import Model
from pot_libs.sanic_api.column import List, Str, Enum, Opt, Int
from pot_libs.sanic_api.http_status import unauthorized
from unify_api.utils.response_code import UserErr, DbErr, JwtErr


@dataclass
class ProductAuth(Model):
    cid: Cid = Cid
    shortname: str = Str("工厂名").eg("兴龙轮毂")
    fullname: str = Str("工厂全名称").eg("秦皇岛中秦兴龙轮毂有限公司")
    industry: str = Str("行业").eg("汽车制造")
    province: str = Str("省份").eg("河北省")
    ext_modules: list = List("扩展模块列表").items(Enum("扩展模块id:{0:联动控制}").of(0))
    logo_url: str = Opt(Str("logo地址").eg("2020-07-29 23:59:59"))


@dataclass()
class ProductAuthResponse(Model, UserErr, DbErr, JwtErr):
    cid_info: list = List("产品信息列表").items(ProductAuth)


@dataclass()
class ProxyNameReq(Model, UserErr, DbErr, JwtErr):
    product: int = Int("产品 1-知电U 2-安电U 3-安电u管理版本 4-识电u")


@dataclass
class ProxyItem(Model):
    proxy_id: str = Str("代理id").eg("12")
    proxy_full_name: str = Str("代理全名称").eg("福田住建局")
    proxy_short_name: str = Str("代理简称").eg("福田住建局")


@dataclass()
class ProxyNameResponse(Model, UserErr, DbErr, JwtErr):
    proxy_list: list = List().items(ProxyItem)
