import os
import pandas as pd
import pprint as pp

from unify_api.modules.shidianu.procedures.power_param import power_p
from unify_api.modules.shidianu.service.IntergratePipe import SDU_DIR


async def params_mining(date_time_list, sid, sn):
    """数据预处理脚本，生成pa100-pa3000"""
    time_intevels_pa = {
        "00:01": {0: 0, 100: 0, 200: 0, 300: 0, 400: 0, 500: 0, 600: 0, 700: 0,
                  800: 0, 900: 0, 1000: 0, 1100: 0,
                  1200: 0,
                  1300: 0, 1400: 0, 1500: 0, 1600: 0, 1700: 0, 1800: 0,
                  1900: 0, 2000: 0, 2100: 0, 2200: 0, 2300: 0,
                  2400: 0, 2500: 0, 2600: 0, 2700: 0, 2800: 0, 2900: 0,
                  3000: 0},
        "01:02": {0: 0, 100: 0, 200: 0, 300: 0, 400: 0, 500: 0, 600: 0, 700: 0,
                  800: 0, 900: 0, 1000: 0, 1100: 0,
                  1200: 0,
                  1300: 0, 1400: 0, 1500: 0, 1600: 0, 1700: 0, 1800: 0,
                  1900: 0, 2000: 0, 2100: 0, 2200: 0, 2300: 0,
                  2400: 0, 2500: 0, 2600: 0, 2700: 0, 2800: 0, 2900: 0,
                  3000: 0},
        "02:03": {0: 0, 100: 0, 200: 0, 300: 0, 400: 0, 500: 0, 600: 0, 700: 0,
                  800: 0, 900: 0, 1000: 0, 1100: 0,
                  1200: 0,
                  1300: 0, 1400: 0, 1500: 0, 1600: 0, 1700: 0, 1800: 0,
                  1900: 0, 2000: 0, 2100: 0, 2200: 0, 2300: 0,
                  2400: 0, 2500: 0, 2600: 0, 2700: 0, 2800: 0, 2900: 0,
                  3000: 0},
        "03:04": {0: 0, 100: 0, 200: 0, 300: 0, 400: 0, 500: 0, 600: 0, 700: 0,
                  800: 0, 900: 0, 1000: 0, 1100: 0,
                  1200: 0,
                  1300: 0, 1400: 0, 1500: 0, 1600: 0, 1700: 0, 1800: 0,
                  1900: 0, 2000: 0, 2100: 0, 2200: 0, 2300: 0,
                  2400: 0, 2500: 0, 2600: 0, 2700: 0, 2800: 0, 2900: 0,
                  3000: 0},
        "04:05": {0: 0, 100: 0, 200: 0, 300: 0, 400: 0, 500: 0, 600: 0, 700: 0,
                  800: 0, 900: 0, 1000: 0, 1100: 0,
                  1200: 0,
                  1300: 0, 1400: 0, 1500: 0, 1600: 0, 1700: 0, 1800: 0,
                  1900: 0, 2000: 0, 2100: 0, 2200: 0, 2300: 0,
                  2400: 0, 2500: 0, 2600: 0, 2700: 0, 2800: 0, 2900: 0,
                  3000: 0},
        "05:06": {0: 0, 100: 0, 200: 0, 300: 0, 400: 0, 500: 0, 600: 0, 700: 0,
                  800: 0, 900: 0, 1000: 0, 1100: 0,
                  1200: 0,
                  1300: 0, 1400: 0, 1500: 0, 1600: 0, 1700: 0, 1800: 0,
                  1900: 0, 2000: 0, 2100: 0, 2200: 0, 2300: 0,
                  2400: 0, 2500: 0, 2600: 0, 2700: 0, 2800: 0, 2900: 0,
                  3000: 0},
        "06:07": {0: 0, 100: 0, 200: 0, 300: 0, 400: 0, 500: 0, 600: 0, 700: 0,
                  800: 0, 900: 0, 1000: 0, 1100: 0,
                  1200: 0,
                  1300: 0, 1400: 0, 1500: 0, 1600: 0, 1700: 0, 1800: 0,
                  1900: 0, 2000: 0, 2100: 0, 2200: 0, 2300: 0,
                  2400: 0, 2500: 0, 2600: 0, 2700: 0, 2800: 0, 2900: 0,
                  3000: 0},
        "07:08": {0: 0, 100: 0, 200: 0, 300: 0, 400: 0, 500: 0, 600: 0, 700: 0,
                  800: 0, 900: 0, 1000: 0, 1100: 0,
                  1200: 0,
                  1300: 0, 1400: 0, 1500: 0, 1600: 0, 1700: 0, 1800: 0,
                  1900: 0, 2000: 0, 2100: 0, 2200: 0, 2300: 0,
                  2400: 0, 2500: 0, 2600: 0, 2700: 0, 2800: 0, 2900: 0,
                  3000: 0},
        "08:09": {0: 0, 100: 0, 200: 0, 300: 0, 400: 0, 500: 0, 600: 0, 700: 0,
                  800: 0, 900: 0, 1000: 0, 1100: 0,
                  1200: 0,
                  1300: 0, 1400: 0, 1500: 0, 1600: 0, 1700: 0, 1800: 0,
                  1900: 0, 2000: 0, 2100: 0, 2200: 0, 2300: 0,
                  2400: 0, 2500: 0, 2600: 0, 2700: 0, 2800: 0, 2900: 0,
                  3000: 0},
        "09:10": {0: 0, 100: 0, 200: 0, 300: 0, 400: 0, 500: 0, 600: 0, 700: 0,
                  800: 0, 900: 0, 1000: 0, 1100: 0,
                  1200: 0,
                  1300: 0, 1400: 0, 1500: 0, 1600: 0, 1700: 0, 1800: 0,
                  1900: 0, 2000: 0, 2100: 0, 2200: 0, 2300: 0,
                  2400: 0, 2500: 0, 2600: 0, 2700: 0, 2800: 0, 2900: 0,
                  3000: 0},
        "10:11": {0: 0, 100: 0, 200: 0, 300: 0, 400: 0, 500: 0, 600: 0, 700: 0,
                  800: 0, 900: 0, 1000: 0, 1100: 0,
                  1200: 0,
                  1300: 0, 1400: 0, 1500: 0, 1600: 0, 1700: 0, 1800: 0,
                  1900: 0, 2000: 0, 2100: 0, 2200: 0, 2300: 0,
                  2400: 0, 2500: 0, 2600: 0, 2700: 0, 2800: 0, 2900: 0,
                  3000: 0},
        "11:12": {0: 0, 100: 0, 200: 0, 300: 0, 400: 0, 500: 0, 600: 0, 700: 0,
                  800: 0, 900: 0, 1000: 0, 1100: 0,
                  1200: 0,
                  1300: 0, 1400: 0, 1500: 0, 1600: 0, 1700: 0, 1800: 0,
                  1900: 0, 2000: 0, 2100: 0, 2200: 0, 2300: 0,
                  2400: 0, 2500: 0, 2600: 0, 2700: 0, 2800: 0, 2900: 0,
                  3000: 0},
        "12:13": {0: 0, 100: 0, 200: 0, 300: 0, 400: 0, 500: 0, 600: 0, 700: 0,
                  800: 0, 900: 0, 1000: 0, 1100: 0,
                  1200: 0,
                  1300: 0, 1400: 0, 1500: 0, 1600: 0, 1700: 0, 1800: 0,
                  1900: 0, 2000: 0, 2100: 0, 2200: 0, 2300: 0,
                  2400: 0, 2500: 0, 2600: 0, 2700: 0, 2800: 0, 2900: 0,
                  3000: 0},
        "13:14": {0: 0, 100: 0, 200: 0, 300: 0, 400: 0, 500: 0, 600: 0, 700: 0,
                  800: 0, 900: 0, 1000: 0, 1100: 0,
                  1200: 0,
                  1300: 0, 1400: 0, 1500: 0, 1600: 0, 1700: 0, 1800: 0,
                  1900: 0, 2000: 0, 2100: 0, 2200: 0, 2300: 0,
                  2400: 0, 2500: 0, 2600: 0, 2700: 0, 2800: 0, 2900: 0,
                  3000: 0},
        "14:15": {0: 0, 100: 0, 200: 0, 300: 0, 400: 0, 500: 0, 600: 0, 700: 0,
                  800: 0, 900: 0, 1000: 0, 1100: 0,
                  1200: 0,
                  1300: 0, 1400: 0, 1500: 0, 1600: 0, 1700: 0, 1800: 0,
                  1900: 0, 2000: 0, 2100: 0, 2200: 0, 2300: 0,
                  2400: 0, 2500: 0, 2600: 0, 2700: 0, 2800: 0, 2900: 0,
                  3000: 0},
        "15:16": {0: 0, 100: 0, 200: 0, 300: 0, 400: 0, 500: 0, 600: 0, 700: 0,
                  800: 0, 900: 0, 1000: 0, 1100: 0,
                  1200: 0,
                  1300: 0, 1400: 0, 1500: 0, 1600: 0, 1700: 0, 1800: 0,
                  1900: 0, 2000: 0, 2100: 0, 2200: 0, 2300: 0,
                  2400: 0, 2500: 0, 2600: 0, 2700: 0, 2800: 0, 2900: 0,
                  3000: 0},
        "16:17": {0: 0, 100: 0, 200: 0, 300: 0, 400: 0, 500: 0, 600: 0, 700: 0,
                  800: 0, 900: 0, 1000: 0, 1100: 0,
                  1200: 0,
                  1300: 0, 1400: 0, 1500: 0, 1600: 0, 1700: 0, 1800: 0,
                  1900: 0, 2000: 0, 2100: 0, 2200: 0, 2300: 0,
                  2400: 0, 2500: 0, 2600: 0, 2700: 0, 2800: 0, 2900: 0,
                  3000: 0},
        "17:18": {0: 0, 100: 0, 200: 0, 300: 0, 400: 0, 500: 0, 600: 0, 700: 0,
                  800: 0, 900: 0, 1000: 0, 1100: 0,
                  1200: 0,
                  1300: 0, 1400: 0, 1500: 0, 1600: 0, 1700: 0, 1800: 0,
                  1900: 0, 2000: 0, 2100: 0, 2200: 0, 2300: 0,
                  2400: 0, 2500: 0, 2600: 0, 2700: 0, 2800: 0, 2900: 0,
                  3000: 0},
        "18:19": {0: 0, 100: 0, 200: 0, 300: 0, 400: 0, 500: 0, 600: 0, 700: 0,
                  800: 0, 900: 0, 1000: 0, 1100: 0,
                  1200: 0,
                  1300: 0, 1400: 0, 1500: 0, 1600: 0, 1700: 0, 1800: 0,
                  1900: 0, 2000: 0, 2100: 0, 2200: 0, 2300: 0,
                  2400: 0, 2500: 0, 2600: 0, 2700: 0, 2800: 0, 2900: 0,
                  3000: 0},
        "19:20": {0: 0, 100: 0, 200: 0, 300: 0, 400: 0, 500: 0, 600: 0, 700: 0,
                  800: 0, 900: 0, 1000: 0, 1100: 0,
                  1200: 0,
                  1300: 0, 1400: 0, 1500: 0, 1600: 0, 1700: 0, 1800: 0,
                  1900: 0, 2000: 0, 2100: 0, 2200: 0, 2300: 0,
                  2400: 0, 2500: 0, 2600: 0, 2700: 0, 2800: 0, 2900: 0,
                  3000: 0},
        "20:21": {0: 0, 100: 0, 200: 0, 300: 0, 400: 0, 500: 0, 600: 0, 700: 0,
                  800: 0, 900: 0, 1000: 0, 1100: 0,
                  1200: 0,
                  1300: 0, 1400: 0, 1500: 0, 1600: 0, 1700: 0, 1800: 0,
                  1900: 0, 2000: 0, 2100: 0, 2200: 0, 2300: 0,
                  2400: 0, 2500: 0, 2600: 0, 2700: 0, 2800: 0, 2900: 0,
                  3000: 0},
        "21:22": {0: 0, 100: 0, 200: 0, 300: 0, 400: 0, 500: 0, 600: 0, 700: 0,
                  800: 0, 900: 0, 1000: 0, 1100: 0,
                  1200: 0,
                  1300: 0, 1400: 0, 1500: 0, 1600: 0, 1700: 0, 1800: 0,
                  1900: 0, 2000: 0, 2100: 0, 2200: 0, 2300: 0,
                  2400: 0, 2500: 0, 2600: 0, 2700: 0, 2800: 0, 2900: 0,
                  3000: 0},
        "22:23": {0: 0, 100: 0, 200: 0, 300: 0, 400: 0, 500: 0, 600: 0, 700: 0,
                  800: 0, 900: 0, 1000: 0, 1100: 0,
                  1200: 0,
                  1300: 0, 1400: 0, 1500: 0, 1600: 0, 1700: 0, 1800: 0,
                  1900: 0, 2000: 0, 2100: 0, 2200: 0, 2300: 0,
                  2400: 0, 2500: 0, 2600: 0, 2700: 0, 2800: 0, 2900: 0,
                  3000: 0},
        "23:24": {0: 0, 100: 0, 200: 0, 300: 0, 400: 0, 500: 0, 600: 0, 700: 0,
                  800: 0, 900: 0, 1000: 0, 1100: 0,
                  1200: 0,
                  1300: 0, 1400: 0, 1500: 0, 1600: 0, 1700: 0, 1800: 0,
                  1900: 0, 2000: 0, 2100: 0, 2200: 0, 2300: 0,
                  2400: 0, 2500: 0, 2600: 0, 2700: 0, 2800: 0, 2900: 0,
                  3000: 0}
    }
    dataDict = {"time": [], "pa_100": [], "pa_200": [], "pa_300": [],
                "pa_400": [], "pa_500": [], "pa_600": [], "pa_700": [],
                "pa_800": [], "pa_900": [], "pa_1000": [], "pa_1100": [],
                "pa_1200": [], "pa_1300": [], "pa_1400": [], "pa_1500": [],
                "pa_1600": [], "pa_1700": [], "pa_1800": [], "pa_1900": [],
                "pa_2000": [], "pa_2100": [], "pa_2200": [], "pa_2300": [],
                "pa_2400": [], "pa_2500": [], "pa_2600": [], "pa_2700": [],
                "pa_2800": [], "pa_2900": [], "pa_3000": []}
    for key, date_time in enumerate(date_time_list):
        # 1. 从数据获取这天的功率数据,转换成dateframe:eachdata
        p_list, each_data_list = await power_p(sid, sn, date_time)
        eachdata = pd.DataFrame(each_data_list, columns=['time', 'p', 'i'])
        day_time_all = eachdata["time"].values
        power_pa = eachdata["p"].values
        # power_pb = eachdata["pb"].values
        # power_pc = eachdata["pc"].values
        day_time_all = [
            pd.to_datetime(day_time_all[i], format='%Y-%m-%d %H:%M:%S') for
            i in range(len(day_time_all))]
        power_pa_Series = pd.Series(power_pa, index=day_time_all)
        power_pa_Series=power_pa_Series.interpolate(method='nearest')
        # power_pb_Series = pd.Series(power_pb, index=day_time_all)
        # power_pc_Series = pd.Series(power_pc, index=day_time_all)

        power_pa_Series_diff = power_pa_Series.diff(1)[1:]
        # power_pb_Series_diff = power_pb_Series.diff(1)
        # power_pc_Series_diff = power_pc_Series.diff(1)
        power_Series_diff_index = power_pa_Series_diff.index
        power_pa_count = [[str(power_Series_diff_index[each]).split(" ")[
                               1][:2] + ":0" + str(
            int(str(power_Series_diff_index[each]).split(" ")[1][:2]) + 1),
                           int(1000 * power_pa_Series_diff[
                               each]) // 100 * 100] if int(
            str(power_Series_diff_index[each]).split(" ")[1][
            :2]) <= 8 else [
            str(power_Series_diff_index[each]).split(" ")[1][
            :2] + ":" + str(
                int(str(power_Series_diff_index[each]).split(" ")[1][
                    :2]) + 1),
            int(1000 * power_pa_Series_diff[each]) // 100 * 100] for each
                          in range(1, len(power_pa_Series_diff)) if
                          int(1000 * power_pa_Series_diff[each]) > 0]

        power_pa_count_str = [str(each) for each in power_pa_count]
        power_pa_set = set(power_pa_count_str)
        for each in power_pa_set:
            each1 = eval(each)
            time_intevels_pa[each1[0]][
                each1[1]] = power_pa_count_str.count(each)

        pa_100 = [time_intevels_pa[key][100] for key in
                  time_intevels_pa.keys()]
        pa_200 = [time_intevels_pa[key][200] for key in
                  time_intevels_pa.keys()]
        pa_300 = [time_intevels_pa[key][300] for key in
                  time_intevels_pa.keys()]
        pa_400 = [time_intevels_pa[key][400] for key in
                  time_intevels_pa.keys()]
        pa_500 = [time_intevels_pa[key][500] for key in
                  time_intevels_pa.keys()]
        pa_600 = [time_intevels_pa[key][600] for key in
                  time_intevels_pa.keys()]
        pa_700 = [time_intevels_pa[key][700] for key in
                  time_intevels_pa.keys()]
        pa_800 = [time_intevels_pa[key][800] for key in
                  time_intevels_pa.keys()]
        pa_900 = [time_intevels_pa[key][900] for key in
                  time_intevels_pa.keys()]
        pa_1000 = [time_intevels_pa[key][1000] for key in
                   time_intevels_pa.keys()]
        pa_1100 = [time_intevels_pa[key][1100] for key in
                   time_intevels_pa.keys()]
        pa_1200 = [time_intevels_pa[key][1200] for key in
                   time_intevels_pa.keys()]
        pa_1300 = [time_intevels_pa[key][1300] for key in
                   time_intevels_pa.keys()]
        pa_1400 = [time_intevels_pa[key][1400] for key in
                   time_intevels_pa.keys()]
        pa_1500 = [time_intevels_pa[key][1500] for key in
                   time_intevels_pa.keys()]
        pa_1600 = [time_intevels_pa[key][1600] for key in
                   time_intevels_pa.keys()]
        pa_1700 = [time_intevels_pa[key][1700] for key in
                   time_intevels_pa.keys()]
        pa_1800 = [time_intevels_pa[key][1800] for key in
                   time_intevels_pa.keys()]
        pa_1900 = [time_intevels_pa[key][1900] for key in
                   time_intevels_pa.keys()]
        pa_2000 = [time_intevels_pa[key][2000] for key in
                   time_intevels_pa.keys()]
        pa_2100 = [time_intevels_pa[key][2100] for key in
                   time_intevels_pa.keys()]
        pa_2200 = [time_intevels_pa[key][2200] for key in
                   time_intevels_pa.keys()]
        pa_2300 = [time_intevels_pa[key][2300] for key in
                   time_intevels_pa.keys()]
        pa_2400 = [time_intevels_pa[key][2400] for key in
                   time_intevels_pa.keys()]
        pa_2500 = [time_intevels_pa[key][2500] for key in
                   time_intevels_pa.keys()]
        pa_2600 = [time_intevels_pa[key][2600] for key in
                   time_intevels_pa.keys()]
        pa_2700 = [time_intevels_pa[key][2700] for key in
                   time_intevels_pa.keys()]
        pa_2800 = [time_intevels_pa[key][2800] for key in
                   time_intevels_pa.keys()]
        pa_2900 = [time_intevels_pa[key][2900] for key in
                   time_intevels_pa.keys()]
        pa_3000 = [time_intevels_pa[key][3000] for key in
                   time_intevels_pa.keys()]

        keys = list(time_intevels_pa.keys())

        dataDict['time'] = keys
        dataDict['pa_100'] = pa_100
        dataDict['pa_200'] = pa_200
        dataDict['pa_300'] = pa_300
        dataDict['pa_400'] = pa_400
        dataDict['pa_500'] = pa_500
        dataDict['pa_600'] = pa_600
        dataDict['pa_700'] = pa_700
        dataDict['pa_800'] = pa_800
        dataDict['pa_900'] = pa_900
        dataDict['pa_1000'] = pa_1000
        dataDict['pa_1100'] = pa_1100
        dataDict['pa_1200'] = pa_1200
        dataDict['pa_1300'] = pa_1300
        dataDict['pa_1400'] = pa_1400
        dataDict['pa_1500'] = pa_1500
        dataDict['pa_1600'] = pa_1600
        dataDict['pa_1700'] = pa_1700
        dataDict['pa_1800'] = pa_1800
        dataDict['pa_1900'] = pa_1900
        dataDict['pa_2000'] = pa_2000
        dataDict['pa_2100'] = pa_2100
        dataDict['pa_2200'] = pa_2200
        dataDict['pa_2300'] = pa_2300
        dataDict['pa_2400'] = pa_2400
        dataDict['pa_2500'] = pa_2500
        dataDict['pa_2600'] = pa_2600
        dataDict['pa_2700'] = pa_2700
        dataDict['pa_2800'] = pa_2800
        dataDict['pa_2900'] = pa_2900
        dataDict['pa_3000'] = pa_3000
        if key == 0:
            result = pd.DataFrame(dataDict)
        else:
            result = result.append(pd.DataFrame(dataDict))
        # result.append(pd.DataFrame(dataDict))
    return result


def paramAnalysis(hisdata):
    """生成节点参数
        保存在：E:\projects\powerDecomp\params
    """
    electroFuran_hold = 0
    riceCook_hold = 0
    heater_hold = 0
    # hisdata = params_mining(dateCur=dateCur, daysLen=daysLen, sid="sid", node="a")
    powerGradeList = ["pa_100", "pa_200", "pa_300", "pa_400", "pa_500",
                      "pa_600", "pa_700", "pa_800", "pa_900", "pa_1000",
                      "pa_1100", "pa_1200", "pa_1300", "pa_1400", "pa_1500",
                      "pa_1600", "pa_1700", "pa_1800", "pa_1900",
                      "pa_2000", "pa_2100", "pa_2200", "pa_2300", "pa_2400",
                      "pa_2500", "pa_2600", "pa_2700", "pa_2800",
                      "pa_2900", "pa_3000"]

    total_day = len(hisdata)
    eachpowgradeData = hisdata[powerGradeList].sum()
    sum_val = list(eachpowgradeData)
    eachday_count = max(sum_val) / total_day

    output = "refrig_hold" + "," + "airCond_hold" + "," + "heater_hold" + "," + "riceCook_hold" + "," + "electroFuran_hold"
    if eachday_count // 24 > 0.3:
        refrig_hold = int(
            powerGradeList[sum_val.index(max(sum_val))].split("_")[1])
        sum_val[sum_val.index(max(sum_val))] = 0
        eachday_count = max(sum_val) / total_day
        if eachday_count / 24 > 0.2:
            airCond_hold = int(
                powerGradeList[sum_val.index(max(sum_val))].split("_")[1])
            sum_val[sum_val.index(max(sum_val))] = 0
            day_aver = [each / total_day for each in sum_val]
            for i in range(1, len(sum_val) - 3):
                if sum(day_aver[i:i + 3]) > 0.5 and sum(
                        day_aver[i:i + 3]) < 2 and i > 8:
                    heater_hold = int(powerGradeList[i].split("_")[1])
                    break
            for i in range(1, len(sum_val) - 3):
                if sum(day_aver[i:i + 3]) > 2 and i > 8 and i < 12:
                    riceCook_hold = int(powerGradeList[i].split("_")[1])
                    break
            for i in range(1, len(sum_val) - 3):
                if sum(day_aver[i:i + 3]) > 2 and i >= 12:
                    electroFuran_hold = int(
                        powerGradeList[i].split("_")[1])
                    break
            output = str(refrig_hold) + "," + str(airCond_hold) + "," + str(
                heater_hold) + "," + str(riceCook_hold) + "," + str(
                electroFuran_hold)
            # wf.write(output + "\n")
    if "0" not in output and "1" not in output:
        return "100,300,1200,1000,1300,1"
    else:
        return output + "," + "0"
