from pot_libs.logger import log
from pot_libs.mysql_util.mysql_util import MysqlUtil


async def get_mtid_dao(cid, sid):
    sql = "select mtid from monitor where sid=%s and cid=%s"
    async with MysqlUtil() as conn:
        data = await conn.fetchone(sql, args=(cid, sid))
    return data


async def get_location_id_dao(mtid):
    sql = "SELECT lid FROM location where ad_type='residual_current' " \
          "and mtid=%s"
    async with MysqlUtil() as conn:
        data = await conn.fetchone(sql, args=(mtid, ))
    return data


async def get_threhold_dao(location_id):
    sql = "select threshold from alarm_setting " \
          "where type='overResidualCurrent' and  location_id=%s"
    async with MysqlUtil() as conn:
        data = await conn.fetchone(sql, args=(location_id,))
    return data


async def get_point_name_dao(pid):
    sql = "SELECT pid, name FROM point where pid=%s"
    async with MysqlUtil() as conn:
        data = await conn.fetchone(sql, args=(pid, ))
    return data


async def get_trigger_params_dao(type_id):
    sql = "select name from event_type WHERE id=%s"
    async with MysqlUtil() as conn:
        data = await conn.fetchone(sql, args=(type_id, ))
    return data
